/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;

public class CommandResponseHandler {
    private static final TextComponent PREFIX = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of("[", TextColor.DARK_GRAY))).append((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("\u26a1").color(TextColor.YELLOW)).decoration(TextDecoration.BOLD, TextDecoration.State.TRUE)).build())).append(TextComponent.of("]", TextColor.DARK_GRAY))).append(TextComponent.of(" "))).build();
    private final SparkPlatform platform;
    private final CommandSender sender;

    public CommandResponseHandler(SparkPlatform platform, CommandSender sender) {
        this.platform = platform;
        this.sender = sender;
    }

    public CommandSender sender() {
        return this.sender;
    }

    public void allSenders(Consumer<? super CommandSender> action) {
        Set<? super CommandSender> senders = this.platform.getPlugin().getSendersWithPermission("spark").collect(Collectors.toSet());
        senders.add(this.sender);
        senders.forEach(action);
    }

    public void reply(Component message) {
        this.sender.sendMessage(message);
    }

    public void broadcast(Component message) {
        this.allSenders(sender -> sender.sendMessage(message));
    }

    public void replyPrefixed(Component message) {
        this.reply(CommandResponseHandler.applyPrefix(message));
    }

    public void broadcastPrefixed(Component message) {
        this.broadcast(CommandResponseHandler.applyPrefix(message));
    }

    public static Component applyPrefix(Component message) {
        return PREFIX.append(message);
    }
}

