/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.lucko.spark.common.activitylog.ActivityLog;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.event.ClickEvent;
import me.lucko.spark.lib.text.feature.pagination.Pagination;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;

public class ActivityLogModule
implements CommandModule,
Pagination.Renderer.RowRenderer<ActivityLog.Activity> {
    private final Pagination.Builder pagination = Pagination.builder().renderer(new Pagination.Renderer(){

        @Override
        public Component renderEmpty() {
            return CommandResponseHandler.applyPrefix(TextComponent.of("There are no entries present in the log."));
        }

        @Override
        public Component renderUnknownPage(int page, int pages) {
            return CommandResponseHandler.applyPrefix(TextComponent.of("Unknown page selected. " + pages + " total pages."));
        }
    }).resultsPerPage(4);

    @Override
    public Collection<Component> renderRow(ActivityLog.Activity activity, int index) {
        ArrayList<Component> reply = new ArrayList<Component>(5);
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").append((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder(">").color(TextColor.DARK_GRAY)).decoration(TextDecoration.BOLD, true)).build())).append(TextComponent.space())).append(TextComponent.of("#" + (index + 1), TextColor.WHITE))).append(TextComponent.of(" - ", TextColor.DARK_GRAY))).append(TextComponent.of(activity.getType(), TextColor.YELLOW))).append(TextComponent.of(" - ", TextColor.DARK_GRAY))).append(TextComponent.of(ActivityLogModule.formatDateDiff(activity.getTime()), TextColor.GRAY))).build());
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("  ").append(TextComponent.of("Created by: ", TextColor.GRAY))).append(TextComponent.of(activity.getUser().getName(), TextColor.WHITE))).build());
        TextComponent.Builder valueComponent = TextComponent.builder(activity.getDataValue(), TextColor.WHITE);
        if (activity.getDataType().equals("url")) {
            valueComponent.clickEvent(ClickEvent.openUrl(activity.getDataValue()));
        }
        reply.add((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("  ").append(TextComponent.of(Character.toUpperCase(activity.getDataType().charAt(0)) + activity.getDataType().substring(1) + ": ", TextColor.GRAY))).append(valueComponent)).build());
        reply.add(TextComponent.space());
        return reply;
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("activity", "activitylog", "log").argumentUsage("page", "page no").executor((platform, sender, resp, arguments) -> {
            List<ActivityLog.Activity> log = platform.getActivityLog().getLog();
            log.removeIf(ActivityLog.Activity::shouldExpire);
            if (log.isEmpty()) {
                resp.replyPrefixed(TextComponent.of("There are no entries present in the log."));
                return;
            }
            int page = Math.max(1, arguments.intFlag("page"));
            Pagination<ActivityLog.Activity> activityPagination = this.pagination.build(TextComponent.of("Recent spark activity", TextColor.GOLD), this, value -> "/" + platform.getPlugin().getCommandName() + " activity --page " + value);
            activityPagination.render(log, page).forEach(resp::reply);
        }).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--page")).build());
    }

    private static String formatDateDiff(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        if (seconds <= 0L) {
            return "now";
        }
        long minute = seconds / 60L;
        seconds %= 60L;
        long hour = minute / 60L;
        minute %= 60L;
        long day = hour / 24L;
        hour %= 24L;
        StringBuilder sb = new StringBuilder();
        if (day != 0L) {
            sb.append(day).append("d ");
        }
        if (hour != 0L) {
            sb.append(hour).append("h ");
        }
        if (minute != 0L) {
            sb.append(minute).append("m ");
        }
        if (seconds != 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim() + " ago";
    }
}

