/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.activitylog.ActivityLog;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.tabcomplete.CompletionSupplier;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.sampler.Sampler;
import me.lucko.spark.common.sampler.SamplerBuilder;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.ThreadNodeOrder;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.lib.okhttp3.MediaType;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.event.ClickEvent;
import me.lucko.spark.lib.text.format.TextColor;

public class SamplerModule
implements CommandModule {
    private static final MediaType SPARK_SAMPLER_MEDIA_TYPE = MediaType.parse("application/x-spark-sampler");
    private Sampler activeSampler = null;

    @Override
    public void close() {
        if (this.activeSampler != null) {
            this.activeSampler.cancel();
            this.activeSampler = null;
        }
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("sampler").argumentUsage("info", null).argumentUsage("stop", null).argumentUsage("cancel", null).argumentUsage("timeout", "timeout seconds").argumentUsage("thread", "thread name").argumentUsage("regex", null).argumentUsage("combine-all", null).argumentUsage("not-combined", null).argumentUsage("interval", "interval millis").argumentUsage("only-ticks-over", "tick length millis").argumentUsage("include-line-numbers", null).argumentUsage("ignore-sleeping", null).argumentUsage("order-by-time", null).executor((platform, sender, resp, arguments) -> {
            double intervalMillis;
            if (arguments.boolFlag("info")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(TextComponent.of("There isn't an active sampling task running."));
                } else {
                    long timeout = this.activeSampler.getEndTime();
                    if (timeout == -1L) {
                        resp.replyPrefixed(TextComponent.of("There is an active sampler currently running, with no defined timeout."));
                    } else {
                        long timeoutDiff = (timeout - System.currentTimeMillis()) / 1000L;
                        resp.replyPrefixed(TextComponent.of("There is an active sampler currently running, due to timeout in " + timeoutDiff + " seconds."));
                    }
                    long runningTime = (System.currentTimeMillis() - this.activeSampler.getStartTime()) / 1000L;
                    resp.replyPrefixed(TextComponent.of("It has been sampling for " + runningTime + " seconds so far."));
                }
                return;
            }
            if (arguments.boolFlag("cancel")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(TextComponent.of("There isn't an active sampling task running."));
                } else {
                    this.close();
                    resp.broadcastPrefixed(TextComponent.of("The active sampling task has been cancelled.", TextColor.GOLD));
                }
                return;
            }
            if (arguments.boolFlag("stop") || arguments.boolFlag("upload")) {
                if (this.activeSampler == null) {
                    resp.replyPrefixed(TextComponent.of("There isn't an active sampling task running."));
                } else {
                    this.activeSampler.cancel();
                    resp.broadcastPrefixed(TextComponent.of("The active sampling operation has been stopped! Uploading results..."));
                    ThreadNodeOrder threadOrder = arguments.boolFlag("order-by-time") ? ThreadNodeOrder.BY_TIME : ThreadNodeOrder.BY_NAME;
                    this.handleUpload(platform, resp, this.activeSampler, threadOrder);
                    this.activeSampler = null;
                }
                return;
            }
            int timeoutSeconds = arguments.intFlag("timeout");
            if (timeoutSeconds != -1 && timeoutSeconds <= 10) {
                resp.replyPrefixed(TextComponent.of("The specified timeout is not long enough for accurate results to be formed. Please choose a value greater than 10.", TextColor.RED));
                return;
            }
            if (timeoutSeconds != -1 && timeoutSeconds < 30) {
                resp.replyPrefixed(TextComponent.of("The accuracy of the output will significantly improve when sampling is able to run for longer periods. Consider setting a timeout value over 30 seconds."));
            }
            if ((intervalMillis = arguments.doubleFlag("interval")) <= 0.0) {
                intervalMillis = 4.0;
            }
            boolean includeLineNumbers = arguments.boolFlag("include-line-numbers");
            boolean ignoreSleeping = arguments.boolFlag("ignore-sleeping");
            Set<String> threads = arguments.stringFlag("thread");
            ThreadDumper threadDumper = threads.isEmpty() ? platform.getPlugin().getDefaultThreadDumper() : (threads.contains("*") ? ThreadDumper.ALL : (arguments.boolFlag("regex") ? new ThreadDumper.Regex(threads) : new ThreadDumper.Specific(threads)));
            ThreadGrouper threadGrouper = arguments.boolFlag("combine-all") ? ThreadGrouper.AS_ONE : (arguments.boolFlag("not-combined") ? ThreadGrouper.BY_NAME : ThreadGrouper.BY_POOL);
            int ticksOver = arguments.intFlag("only-ticks-over");
            TickHook tickHook = null;
            if (ticksOver != -1 && (tickHook = platform.getTickHook()) == null) {
                resp.replyPrefixed(TextComponent.of("Tick counting is not supported!", TextColor.RED));
                return;
            }
            if (this.activeSampler != null) {
                resp.replyPrefixed(TextComponent.of("An active sampler is already running."));
                return;
            }
            resp.broadcastPrefixed(TextComponent.of("Initializing a new profiler, please wait..."));
            SamplerBuilder builder = new SamplerBuilder();
            builder.threadDumper(threadDumper);
            builder.threadGrouper(threadGrouper);
            if (timeoutSeconds != -1) {
                builder.completeAfter(timeoutSeconds, TimeUnit.SECONDS);
            }
            builder.samplingInterval(intervalMillis);
            builder.includeLineNumbers(includeLineNumbers);
            builder.ignoreSleeping(ignoreSleeping);
            if (ticksOver != -1) {
                builder.ticksOver(ticksOver, tickHook);
            }
            Sampler sampler = this.activeSampler = builder.start();
            resp.broadcastPrefixed(TextComponent.of("Profiler now active!", TextColor.GOLD));
            if (timeoutSeconds == -1) {
                resp.broadcastPrefixed(TextComponent.of("Use '/" + platform.getPlugin().getCommandName() + " sampler --stop' to stop profiling and upload the results."));
            } else {
                resp.broadcastPrefixed(TextComponent.of("The results will be automatically returned after the profiler has been running for " + timeoutSeconds + " seconds."));
            }
            CompletableFuture<Sampler> future = this.activeSampler.getFuture();
            future.whenCompleteAsync((s, throwable) -> {
                if (throwable != null) {
                    resp.broadcastPrefixed(TextComponent.of("Sampling operation failed unexpectedly. Error: " + throwable.toString(), TextColor.RED));
                    throwable.printStackTrace();
                }
            });
            future.whenCompleteAsync((s, throwable) -> {
                if (sampler == this.activeSampler) {
                    this.activeSampler = null;
                }
            });
            if (timeoutSeconds != -1) {
                ThreadNodeOrder threadOrder = arguments.boolFlag("order-by-time") ? ThreadNodeOrder.BY_TIME : ThreadNodeOrder.BY_NAME;
                future.thenAcceptAsync(s -> {
                    resp.broadcastPrefixed(TextComponent.of("The active sampling operation has completed! Uploading results..."));
                    this.handleUpload(platform, resp, (Sampler)s, threadOrder);
                });
            }
        }).tabCompleter((platform, sender, arguments) -> {
            if (arguments.contains("--info") || arguments.contains("--cancel")) {
                return Collections.emptyList();
            }
            if (arguments.contains("--stop") || arguments.contains("--upload")) {
                return TabCompleter.completeForOpts(arguments, "--order-by-time");
            }
            ArrayList<String> opts = new ArrayList<String>(Arrays.asList("--info", "--stop", "--cancel", "--timeout", "--regex", "--combine-all", "--not-combined", "--interval", "--only-ticks-over", "--include-line-numbers", "--ignore-sleeping", "--order-by-time"));
            opts.removeAll(arguments);
            opts.add("--thread");
            return TabCompleter.create().from(0, CompletionSupplier.startsWith(opts)).complete(arguments);
        }).build());
    }

    private void handleUpload(SparkPlatform platform, CommandResponseHandler resp, Sampler sampler, ThreadNodeOrder threadOrder) {
        platform.getPlugin().executeAsync(() -> {
            byte[] output = sampler.formCompressedDataPayload(resp.sender(), threadOrder);
            try {
                String key = SparkPlatform.BYTEBIN_CLIENT.postContent(output, SPARK_SAMPLER_MEDIA_TYPE, false).key();
                String url = "https://sparkprofiler.github.io/#" + key;
                resp.broadcastPrefixed(TextComponent.of("Sampling results:", TextColor.GOLD));
                resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder(url).color(TextColor.GRAY)).clickEvent(ClickEvent.openUrl(url))).build());
                platform.getActivityLog().addToLog(ActivityLog.Activity.urlActivity(resp.sender(), System.currentTimeMillis(), "Sampler", url));
            }
            catch (IOException e) {
                resp.broadcastPrefixed(TextComponent.of("An error occurred whilst uploading the results.", TextColor.RED));
                e.printStackTrace();
            }
        });
    }
}

