/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command.modules;

import java.util.function.Consumer;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.Command;
import me.lucko.spark.common.command.CommandModule;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.common.monitor.tick.TickMonitor;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.format.TextColor;

public class TickMonitoringModule
implements CommandModule {
    private TickHook tickHook = null;
    private ReportingTickMonitor activeTickMonitor = null;

    @Override
    public void close() {
        if (this.activeTickMonitor != null) {
            this.tickHook.removeCallback(this.activeTickMonitor);
            this.activeTickMonitor.close();
            this.activeTickMonitor = null;
        }
    }

    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("tickmonitoring").argumentUsage("threshold", "percentage increase").argumentUsage("without-gc", null).executor((platform, sender, resp, arguments) -> {
            if (this.tickHook == null) {
                this.tickHook = platform.getTickHook();
            }
            if (this.tickHook == null) {
                resp.replyPrefixed(TextComponent.of("Not supported!", TextColor.RED));
                return;
            }
            if (this.activeTickMonitor == null) {
                int threshold = arguments.intFlag("threshold");
                if (threshold == -1) {
                    threshold = 100;
                }
                this.activeTickMonitor = new ReportingTickMonitor(platform, resp, this.tickHook, threshold, !arguments.boolFlag("without-gc"));
                this.tickHook.addCallback(this.activeTickMonitor);
            } else {
                this.close();
                resp.broadcastPrefixed(TextComponent.of("Tick monitor disabled."));
            }
        }).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--threshold", "--without-gc")).build());
    }

    private static class ReportingTickMonitor
    extends TickMonitor {
        private final CommandResponseHandler resp;

        ReportingTickMonitor(SparkPlatform platform, CommandResponseHandler resp, TickHook tickHook, int percentageChangeThreshold, boolean monitorGc) {
            super(platform, tickHook, percentageChangeThreshold, monitorGc);
            this.resp = resp;
        }

        @Override
        protected void sendMessage(Component message) {
            this.resp.broadcastPrefixed(message);
        }
    }
}

