/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.heapdump;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.util.TypeDescriptors;
import me.lucko.spark.proto.SparkProtos;

public final class HeapDumpSummary {
    private static final String DIAGNOSTIC_BEAN = "com.sun.management:type=DiagnosticCommand";
    private static final Pattern OUTPUT_FORMAT = Pattern.compile("^\\s*(\\d+):\\s*(\\d+)\\s*(\\d+)\\s*([^\\s]+).*$");
    private final List<Entry> entries;

    private static String getRawHeapData() throws Exception {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName diagnosticBeanName = ObjectName.getInstance(DIAGNOSTIC_BEAN);
        DiagnosticCommandMXBean proxy = JMX.newMXBeanProxy(beanServer, diagnosticBeanName, DiagnosticCommandMXBean.class);
        return proxy.gcClassHistogram(new String[0]);
    }

    public static HeapDumpSummary createNew() {
        String rawOutput;
        try {
            rawOutput = HeapDumpSummary.getRawHeapData();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get heap dump", e);
        }
        return new HeapDumpSummary(Arrays.stream(rawOutput.split("\n")).map(line -> {
            Matcher matcher = OUTPUT_FORMAT.matcher((CharSequence)line);
            if (!matcher.matches()) {
                return null;
            }
            try {
                return new Entry(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Long.parseLong(matcher.group(3)), TypeDescriptors.getJavaType(matcher.group(4)));
            }
            catch (Exception e) {
                new IllegalArgumentException("Exception parsing line: " + line, e).printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private HeapDumpSummary(List<Entry> entries) {
        this.entries = entries;
    }

    private SparkProtos.HeapData toProto(CommandSender creator) {
        SparkProtos.HeapData.Builder proto = SparkProtos.HeapData.newBuilder();
        proto.setMetadata(SparkProtos.HeapMetadata.newBuilder().setUser(creator.toData().toProto()).build());
        for (Entry entry : this.entries) {
            proto.addEntries(entry.toProto());
        }
        return proto.build();
    }

    public byte[] formCompressedDataPayload(CommandSender creator) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(byteOut);){
            this.toProto(creator).writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteOut.toByteArray();
    }

    public static interface DiagnosticCommandMXBean {
        public String gcClassHistogram(String[] var1);
    }

    public static final class Entry {
        private final int order;
        private final int instances;
        private final long bytes;
        private final String type;

        Entry(int order, int instances, long bytes, String type) {
            this.order = order;
            this.instances = instances;
            this.bytes = bytes;
            this.type = type;
        }

        public int getOrder() {
            return this.order;
        }

        public int getInstances() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public String getType() {
            return this.type;
        }

        public SparkProtos.HeapEntry toProto() {
            return SparkProtos.HeapEntry.newBuilder().setOrder(this.order).setInstances(this.instances).setSize(this.bytes).setType(this.type).build();
        }
    }
}

