/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.tick;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.text.DecimalFormat;
import java.util.DoubleSummaryStatistics;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.memory.GarbageCollectionMonitor;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.format.TextColor;

public abstract class TickMonitor
implements TickHook.Callback,
GarbageCollectionMonitor.Listener,
AutoCloseable {
    private static final DecimalFormat df = new DecimalFormat("#.##");
    private final SparkPlatform platform;
    private final TickHook tickHook;
    private final int zeroTick;
    private final GarbageCollectionMonitor garbageCollectionMonitor;
    private final int percentageChangeThreshold;
    private volatile double lastTickTime = 0.0;
    private State state = null;
    private final DoubleSummaryStatistics averageTickTime = new DoubleSummaryStatistics();
    private double avg;

    public TickMonitor(SparkPlatform platform, TickHook tickHook, int percentageChangeThreshold, boolean monitorGc) {
        this.platform = platform;
        this.tickHook = tickHook;
        this.zeroTick = tickHook.getCurrentTick();
        this.percentageChangeThreshold = percentageChangeThreshold;
        if (monitorGc) {
            this.garbageCollectionMonitor = new GarbageCollectionMonitor();
            this.garbageCollectionMonitor.addListener(this);
        } else {
            this.garbageCollectionMonitor = null;
        }
    }

    public int getCurrentTick() {
        return this.tickHook.getCurrentTick() - this.zeroTick;
    }

    protected abstract void sendMessage(Component var1);

    @Override
    public void close() {
        if (this.garbageCollectionMonitor != null) {
            this.garbageCollectionMonitor.close();
        }
    }

    @Override
    public void onTick(TickHook hook) {
        double now = (double)System.nanoTime() / 1000000.0;
        if (this.state == null) {
            this.state = State.SETUP;
            this.lastTickTime = now;
            this.sendMessage(TextComponent.of("Tick monitor started. Before the monitor becomes fully active, the server's average tick rate will be calculated over a period of 120 ticks (approx 6 seconds)."));
            return;
        }
        double last = this.lastTickTime;
        double diff = now - last;
        boolean ignore = last == 0.0;
        this.lastTickTime = now;
        if (ignore) {
            return;
        }
        if (this.state == State.SETUP) {
            this.averageTickTime.accept(diff);
            if (this.averageTickTime.getCount() >= 120L) {
                this.platform.getPlugin().executeAsync(() -> {
                    this.sendMessage(TextComponent.of("Analysis is now complete.", TextColor.GOLD));
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of(">", TextColor.WHITE))).append(TextComponent.space())).append(TextComponent.of("Max: "))).append(TextComponent.of(df.format(this.averageTickTime.getMax())))).append(TextComponent.of("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of(">", TextColor.WHITE))).append(TextComponent.space())).append(TextComponent.of("Min: "))).append(TextComponent.of(df.format(this.averageTickTime.getMin())))).append(TextComponent.of("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of(">", TextColor.WHITE))).append(TextComponent.space())).append(TextComponent.of("Avg: "))).append(TextComponent.of(df.format(this.averageTickTime.getAverage())))).append(TextComponent.of("ms"))).build());
                    this.sendMessage(TextComponent.of("Starting now, any ticks with >" + this.percentageChangeThreshold + "% increase in duration compared to the average will be reported."));
                });
                this.avg = this.averageTickTime.getAverage();
                this.state = State.MONITORING;
            }
        }
        if (this.state == State.MONITORING) {
            double increase = diff - this.avg;
            if (increase <= 0.0) {
                return;
            }
            double percentageChange = increase * 100.0 / this.avg;
            if (percentageChange > (double)this.percentageChangeThreshold) {
                this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of("Tick "))).append(TextComponent.of("#" + this.getCurrentTick(), TextColor.DARK_GRAY))).append(TextComponent.of(" lasted "))).append(TextComponent.of(df.format(diff), TextColor.GOLD))).append(TextComponent.of(" ms. "))).append(TextComponent.of("("))).append(TextComponent.of(df.format(percentageChange) + "%", TextColor.GOLD))).append(TextComponent.of(" increase from avg)"))).build()));
            }
        }
    }

    @Override
    public void onGc(GarbageCollectionNotificationInfo data) {
        if (this.state == State.SETUP) {
            this.lastTickTime = 0.0;
            return;
        }
        String gcType = data.getGcAction().equals("end of minor GC") ? "Young Gen GC" : (data.getGcAction().equals("end of major GC") ? "Old Gen GC" : data.getGcAction());
        this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("").color(TextColor.GRAY)).append(TextComponent.of("Tick "))).append(TextComponent.of("#" + this.getCurrentTick(), TextColor.DARK_GRAY))).append(TextComponent.of(" included "))).append(TextComponent.of("GC", TextColor.RED))).append(TextComponent.of(" lasting "))).append(TextComponent.of(df.format(data.getGcInfo().getDuration()), TextColor.GOLD))).append(TextComponent.of(" ms. (type = " + gcType + ")"))).build()));
    }

    private static enum State {
        SETUP,
        MONITORING;

    }
}

