/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.aggregator.DataAggregator;
import me.lucko.spark.common.sampler.aggregator.SimpleDataAggregator;
import me.lucko.spark.common.sampler.aggregator.TickedDataAggregator;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.proto.SparkProtos;

public class Sampler
implements Runnable {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    private final ScheduledExecutorService workerPool = Executors.newScheduledThreadPool(6, new ThreadFactoryBuilder().setNameFormat("spark-worker-" + THREAD_ID.getAndIncrement() + "-%d").build());
    private ScheduledFuture<?> task;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private final ThreadDumper threadDumper;
    private final DataAggregator dataAggregator;
    private final CompletableFuture<Sampler> future = new CompletableFuture();
    private final int interval;
    private long startTime = -1L;
    private final long endTime;

    public Sampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean includeLineNumbers, boolean ignoreSleeping) {
        this.threadDumper = threadDumper;
        this.dataAggregator = new SimpleDataAggregator(this.workerPool, threadGrouper, interval, includeLineNumbers, ignoreSleeping);
        this.interval = interval;
        this.endTime = endTime;
    }

    public Sampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime, boolean includeLineNumbers, boolean ignoreSleeping, TickHook tickHook, int tickLengthThreshold) {
        this.threadDumper = threadDumper;
        this.dataAggregator = new TickedDataAggregator(this.workerPool, threadGrouper, interval, includeLineNumbers, ignoreSleeping, tickHook, tickLengthThreshold);
        this.interval = interval;
        this.endTime = endTime;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.task = this.workerPool.scheduleAtFixedRate(this, 0L, this.interval, TimeUnit.MICROSECONDS);
    }

    public long getStartTime() {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Not yet started");
        }
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public CompletableFuture<Sampler> getFuture() {
        return this.future;
    }

    public void cancel() {
        this.task.cancel(false);
    }

    @Override
    public void run() {
        try {
            if (this.endTime != -1L && this.endTime <= System.currentTimeMillis()) {
                this.future.complete(this);
                this.cancel();
                return;
            }
            ThreadInfo[] threadDumps = this.threadDumper.dumpThreads(this.threadBean);
            this.workerPool.execute(new InsertDataTask(this.dataAggregator, threadDumps));
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
            this.cancel();
        }
    }

    private SparkProtos.SamplerData toProto(CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder) {
        SparkProtos.SamplerData.Builder proto = SparkProtos.SamplerData.newBuilder();
        proto.setMetadata(SparkProtos.SamplerMetadata.newBuilder().setUser(creator.toData().toProto()).setStartTime(this.startTime).setInterval(this.interval).setThreadDumper(this.threadDumper.getMetadata()).setDataAggregator(this.dataAggregator.getMetadata()).build());
        ArrayList<Map.Entry<String, ThreadNode>> data = new ArrayList<Map.Entry<String, ThreadNode>>(this.dataAggregator.getData().entrySet());
        data.sort(outputOrder);
        for (Map.Entry entry : data) {
            proto.addThreads(((ThreadNode)entry.getValue()).toProto());
        }
        return proto.build();
    }

    public byte[] formCompressedDataPayload(CommandSender creator, Comparator<? super Map.Entry<String, ThreadNode>> outputOrder) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(byteOut);){
            this.toProto(creator, outputOrder).writeTo(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteOut.toByteArray();
    }

    private static final class InsertDataTask
    implements Runnable {
        private final DataAggregator dataAggregator;
        private final ThreadInfo[] threadDumps;

        InsertDataTask(DataAggregator dataAggregator, ThreadInfo[] threadDumps) {
            this.dataAggregator = dataAggregator;
            this.threadDumps = threadDumps;
        }

        @Override
        public void run() {
            for (ThreadInfo threadInfo : this.threadDumps) {
                if (threadInfo.getThreadName() == null || threadInfo.getStackTrace() == null) continue;
                this.dataAggregator.insertData(threadInfo);
            }
        }
    }
}

