/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import me.lucko.spark.common.util.ThreadFinder;
import me.lucko.spark.proto.SparkProtos;

public interface ThreadDumper {
    public static final ThreadDumper ALL = new ThreadDumper(){

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return threadBean.dumpAllThreads(false, false);
        }

        @Override
        public SparkProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return SparkProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkProtos.SamplerMetadata.ThreadDumper.Type.ALL).build();
        }
    };

    public ThreadInfo[] dumpThreads(ThreadMXBean var1);

    public SparkProtos.SamplerMetadata.ThreadDumper getMetadata();

    public static final class Regex
    implements ThreadDumper {
        private final ThreadFinder threadFinder = new ThreadFinder();
        private final Set<Pattern> namePatterns;
        private final Map<Long, Boolean> cache = new HashMap<Long, Boolean>();

        public Regex(Set<String> namePatterns) {
            this.namePatterns = namePatterns.stream().map(regex -> {
                try {
                    return Pattern.compile(regex, 2);
                }
                catch (PatternSyntaxException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return (ThreadInfo[])this.threadFinder.getThreads().filter(thread -> {
                Boolean result = this.cache.get(thread.getId());
                if (result != null) {
                    return result;
                }
                for (Pattern pattern : this.namePatterns) {
                    if (!pattern.matcher(thread.getName()).matches()) continue;
                    this.cache.put(thread.getId(), true);
                    return true;
                }
                this.cache.put(thread.getId(), false);
                return false;
            }).map(thread -> threadBean.getThreadInfo(thread.getId(), Integer.MAX_VALUE)).filter(Objects::nonNull).toArray(ThreadInfo[]::new);
        }

        @Override
        public SparkProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return SparkProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkProtos.SamplerMetadata.ThreadDumper.Type.REGEX).addAllPatterns(this.namePatterns.stream().map(Pattern::pattern).collect(Collectors.toList())).build();
        }
    }

    public static final class Specific
    implements ThreadDumper {
        private final long[] ids;

        public Specific(long[] ids) {
            this.ids = ids;
        }

        public Specific(Set<String> names) {
            Set namesLower = names.stream().map(String::toLowerCase).collect(Collectors.toSet());
            this.ids = new ThreadFinder().getThreads().filter(t -> namesLower.contains(t.getName().toLowerCase())).mapToLong(Thread::getId).toArray();
        }

        @Override
        public ThreadInfo[] dumpThreads(ThreadMXBean threadBean) {
            return threadBean.getThreadInfo(this.ids, Integer.MAX_VALUE);
        }

        @Override
        public SparkProtos.SamplerMetadata.ThreadDumper getMetadata() {
            return SparkProtos.SamplerMetadata.ThreadDumper.newBuilder().setType(SparkProtos.SamplerMetadata.ThreadDumper.Type.SPECIFIC).addAllIds(Arrays.stream(this.ids).boxed().collect(Collectors.toList())).build();
        }
    }
}

