/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.spark.proto.SparkProtos;

public enum ThreadGrouper {
    BY_NAME{

        @Override
        public String getGroup(long threadId, String threadName) {
            return threadName;
        }
    }
    ,
    BY_POOL{
        private final Map<Long, String> cache = new ConcurrentHashMap<Long, String>();
        private final Pattern pattern = Pattern.compile("^(.*?)[-# ]+\\d+$");

        @Override
        public String getGroup(long threadId, String threadName) {
            String group = this.cache.get(threadId);
            if (group != null) {
                return group;
            }
            Matcher matcher = this.pattern.matcher(threadName);
            if (!matcher.matches()) {
                return threadName;
            }
            group = matcher.group(1).trim() + " (Combined)";
            this.cache.put(threadId, group);
            return group;
        }
    }
    ,
    AS_ONE{

        @Override
        public String getGroup(long threadId, String threadName) {
            return "All";
        }
    };


    public abstract String getGroup(long var1, String var3);

    public static SparkProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto(ThreadGrouper threadGrouper) {
        switch (threadGrouper) {
            case BY_NAME: {
                return SparkProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_NAME;
            }
            case BY_POOL: {
                return SparkProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_POOL;
            }
            case AS_ONE: {
                return SparkProtos.SamplerMetadata.DataAggregator.ThreadGrouper.AS_ONE;
            }
        }
        throw new AssertionError();
    }
}

