/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.aggregator;

import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.aggregator.DataAggregator;
import me.lucko.spark.common.sampler.node.ThreadNode;

public abstract class AbstractDataAggregator
implements DataAggregator {
    protected final Map<String, ThreadNode> threadData = new ConcurrentHashMap<String, ThreadNode>();
    protected final ExecutorService workerPool;
    protected final ThreadGrouper threadGrouper;
    protected final int interval;
    private final boolean includeLineNumbers;
    private final boolean ignoreSleeping;

    public AbstractDataAggregator(ExecutorService workerPool, ThreadGrouper threadGrouper, int interval, boolean includeLineNumbers, boolean ignoreSleeping) {
        this.workerPool = workerPool;
        this.threadGrouper = threadGrouper;
        this.interval = interval;
        this.includeLineNumbers = includeLineNumbers;
        this.ignoreSleeping = ignoreSleeping;
    }

    protected ThreadNode getNode(String group) {
        ThreadNode node = this.threadData.get(group);
        if (node != null) {
            return node;
        }
        return this.threadData.computeIfAbsent(group, ThreadNode::new);
    }

    protected void writeData(ThreadInfo threadInfo) {
        if (this.ignoreSleeping && (threadInfo.getThreadState() == Thread.State.WAITING || threadInfo.getThreadState() == Thread.State.TIMED_WAITING)) {
            return;
        }
        try {
            ThreadNode node = this.getNode(this.threadGrouper.getGroup(threadInfo.getThreadId(), threadInfo.getThreadName()));
            node.log(threadInfo.getStackTrace(), this.interval, this.includeLineNumbers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

