/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import me.lucko.spark.common.sampler.node.StackTraceNode;

public abstract class AbstractNode {
    private static final int MAX_STACK_DEPTH = 300;
    private final Map<String, StackTraceNode> children = new ConcurrentHashMap<String, StackTraceNode>();
    private final LongAdder totalTime = new LongAdder();

    public double getTotalTime() {
        return (double)this.totalTime.longValue() / 1000.0;
    }

    private AbstractNode resolveChild(String className, String methodName, int lineNumber) {
        String key = StackTraceNode.generateKey(className, methodName, lineNumber);
        StackTraceNode result = this.children.get(key);
        if (result != null) {
            return result;
        }
        return this.children.computeIfAbsent(key, name -> new StackTraceNode(className, methodName, lineNumber));
    }

    public void log(StackTraceElement[] elements, long time, boolean includeLineNumbers) {
        this.log(elements, 0, time, includeLineNumbers);
    }

    private void log(StackTraceElement[] elements, int offset, long time, boolean includeLineNumbers) {
        this.totalTime.add(time);
        if (offset >= 300) {
            return;
        }
        if (elements.length - offset == 0) {
            return;
        }
        int pointer = elements.length - 1 - offset;
        StackTraceElement element = elements[pointer];
        StackTraceElement parent = offset == 0 ? null : elements[pointer + 1];
        int lineNumber = parent == null || !includeLineNumbers ? -1 : parent.getLineNumber();
        AbstractNode child = this.resolveChild(element.getClassName(), element.getMethodName(), lineNumber);
        child.log(elements, offset + 1, time, includeLineNumbers);
    }

    protected List<StackTraceNode> getChildren() {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.values());
        list.sort(null);
        return list;
    }
}

