/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import me.lucko.spark.common.sampler.node.AbstractNode;
import me.lucko.spark.proto.SparkProtos;

public final class StackTraceNode
extends AbstractNode
implements Comparable<StackTraceNode> {
    public static final int NULL_LINE_NUMBER = -1;
    private final String className;
    private final String methodName;
    private final int lineNumber;

    static String generateKey(String className, String methodName, int lineNumber) {
        return className + "." + methodName + "." + lineNumber;
    }

    public StackTraceNode(String className, String methodName, int lineNumber) {
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
    }

    public SparkProtos.StackTraceNode toProto() {
        SparkProtos.StackTraceNode.Builder proto = SparkProtos.StackTraceNode.newBuilder().setTime(this.getTotalTime()).setClassName(this.className).setMethodName(this.methodName);
        if (this.lineNumber >= 0) {
            proto.setLineNumber(this.lineNumber);
        }
        for (StackTraceNode child : this.getChildren()) {
            proto.addChildren(child.toProto());
        }
        return proto.build();
    }

    private String key() {
        return StackTraceNode.generateKey(this.className, this.methodName, this.lineNumber);
    }

    @Override
    public int compareTo(StackTraceNode that) {
        int i = -Double.compare(this.getTotalTime(), that.getTotalTime());
        if (i != 0) {
            return i;
        }
        return this.key().compareTo(that.key());
    }
}

