/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Queue;

public class RollingAverage {
    private final Queue<BigDecimal> samples;
    private final int size;
    private BigDecimal total = BigDecimal.ZERO;

    public RollingAverage(int size) {
        this.size = size;
        this.samples = new ArrayDeque<BigDecimal>(this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BigDecimal num) {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            this.total = this.total.add(num);
            this.samples.add(num);
            if (this.samples.size() > this.size) {
                this.total = this.total.subtract(this.samples.remove());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            if (this.samples.isEmpty()) {
                return 0.0;
            }
            return this.total.divide(BigDecimal.valueOf(this.samples.size()), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMax() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            BigDecimal max = BigDecimal.ZERO;
            for (BigDecimal sample : this.samples) {
                if (sample.compareTo(max) <= 0) continue;
                max = sample;
            }
            return max.doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMin() {
        RollingAverage rollingAverage = this;
        synchronized (rollingAverage) {
            BigDecimal min = BigDecimal.ZERO;
            for (BigDecimal sample : this.samples) {
                if (min != BigDecimal.ZERO && sample.compareTo(min) >= 0) continue;
                min = sample;
            }
            return min.doubleValue();
        }
    }
}

