/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

public enum TypeDescriptors {


    public static String getJavaType(String typeDescriptor) {
        return TypeDescriptors.getJavaType(typeDescriptor.toCharArray(), 0);
    }

    private static String getJavaType(char[] buf, int offset) {
        switch (buf[offset]) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'D': {
                return "double";
            }
            case '[': {
                int len = 1;
                while (buf[offset + len] == '[') {
                    ++len;
                }
                StringBuilder sb = new StringBuilder(TypeDescriptors.getJavaType(buf, offset + len));
                for (int i = len; i > 0; --i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            case 'L': {
                int len = 1;
                while (buf[offset + len] != ';') {
                    ++len;
                }
                return new String(buf, offset + 1, len - 1);
            }
        }
        return new String(buf, offset, buf.length - offset);
    }
}

