/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import java.nio.file.Path;
import me.lucko.spark.forge.plugin.ForgeClientSparkPlugin;
import me.lucko.spark.forge.plugin.ForgeServerSparkPlugin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="spark")
public class ForgeSparkMod {
    private ModContainer container;
    private Path configDirectory;

    public ForgeSparkMod() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getVersion() {
        return this.container.getModInfo().getVersion().toString();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        this.container = ModLoadingContext.get().getActiveContainer();
        this.configDirectory = FMLPaths.CONFIGDIR.get().resolve(this.container.getModId());
    }

    @SubscribeEvent
    public void clientInit(FMLClientSetupEvent e) {
        ForgeClientSparkPlugin.register(this, e);
    }

    @SubscribeEvent
    public void serverInit(FMLServerStartingEvent e) {
        ForgeServerSparkPlugin.register(this, e);
    }

    public Path getConfigDirectory() {
        if (this.configDirectory == null) {
            throw new IllegalStateException("Config directory not set");
        }
        return this.configDirectory;
    }
}

