/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.common.sampler.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ForgeClientSparkPlugin
extends ForgeSparkPlugin
implements SuggestionProvider<ISuggestionProvider> {
    private final Minecraft minecraft;
    private CommandDispatcher<ISuggestionProvider> dispatcher;

    public static void register(ForgeSparkMod mod, FMLClientSetupEvent event) {
        Minecraft minecraft = (Minecraft)event.getMinecraftSupplier().get();
        ForgeClientSparkPlugin plugin = new ForgeClientSparkPlugin(mod, minecraft);
        MinecraftForge.EVENT_BUS.register((Object)plugin);
        plugin.scheduler.scheduleWithFixedDelay(plugin::checkCommandRegistered, 10L, 10L, TimeUnit.SECONDS);
    }

    public ForgeClientSparkPlugin(ForgeSparkMod mod, Minecraft minecraft) {
        super(mod);
        this.minecraft = minecraft;
    }

    private CommandDispatcher<ISuggestionProvider> getPlayerCommandDispatcher() {
        return Optional.ofNullable(this.minecraft.field_71439_g).map(player -> player.field_71174_a).map(ClientPlayNetHandler::func_195515_i).orElse(null);
    }

    private void checkCommandRegistered() {
        CommandDispatcher<ISuggestionProvider> dispatcher = this.getPlayerCommandDispatcher();
        if (dispatcher == null) {
            return;
        }
        try {
            if (dispatcher != this.dispatcher) {
                this.dispatcher = dispatcher;
                ForgeClientSparkPlugin.registerCommands(this.dispatcher, context -> 1, this, "sparkc", "sparkclient");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent event) {
        String chat = event.getMessage();
        String[] split = chat.split(" ");
        if (split.length == 0 || !split[0].equals("/sparkc") && !split[0].equals("/sparkclient")) {
            return;
        }
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        this.platform.executeCommand(new ForgeCommandSender((ICommandSource)this.minecraft.field_71439_g, this), args);
        this.minecraft.field_71456_v.func_146158_b().func_146239_a(chat);
        event.setCanceled(true);
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<ISuggestionProvider> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String chat = context.getInput();
        String[] split = chat.split(" ");
        if (split.length == 0 || !split[0].equals("/sparkc") && !split[0].equals("/sparkclient")) {
            return Suggestions.empty();
        }
        String[] args = Arrays.copyOfRange(split, 1, split.length);
        return CompletableFuture.supplyAsync(() -> {
            for (String suggestion : this.platform.tabCompleteCommand(new ForgeCommandSender((ICommandSource)this.minecraft.field_71439_g, this), args)) {
                builder.suggest(suggestion);
            }
            return builder.build();
        });
    }

    @Override
    public boolean hasPermission(ICommandSource sender, String permission) {
        return true;
    }

    public Stream<ForgeCommandSender> getSendersWithPermission(String permission) {
        return Stream.of(new ForgeCommandSender((ICommandSource)this.minecraft.field_71439_g, this));
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.CLIENT);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }
}

