/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.lucko.spark.common.sampler.tick.TickHook;
import me.lucko.spark.common.sampler.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class ForgeServerSparkPlugin
extends ForgeSparkPlugin
implements Command<CommandSource>,
SuggestionProvider<CommandSource> {
    private final MinecraftServer server;

    public static void register(ForgeSparkMod mod, FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ForgeServerSparkPlugin plugin = new ForgeServerSparkPlugin(mod, server);
        CommandDispatcher dispatcher = event.getCommandDispatcher();
        ForgeServerSparkPlugin.registerCommands(dispatcher, plugin, plugin, "spark");
        PermissionAPI.registerNode((String)"spark", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Access to the spark command");
    }

    public ForgeServerSparkPlugin(ForgeSparkMod mod, MinecraftServer server) {
        super(mod);
        this.server = server;
    }

    private static String[] processArgs(CommandContext<CommandSource> context) {
        String[] split = context.getInput().split(" ");
        if (split.length == 0 || !split[0].equals("/spark")) {
            return null;
        }
        return Arrays.copyOfRange(split, 1, split.length);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context);
        if (args == null) {
            return 0;
        }
        this.platform.executeCommand(new ForgeCommandSender((ICommandSource)((CommandSource)context.getSource()).func_197035_h(), this), args);
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = ForgeServerSparkPlugin.processArgs(context);
        if (args == null) {
            return Suggestions.empty();
        }
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        return CompletableFuture.supplyAsync(() -> {
            for (String suggestion : this.platform.tabCompleteCommand(new ForgeCommandSender((ICommandSource)player, this), args)) {
                builder.suggest(suggestion);
            }
            return builder.build();
        });
    }

    @Override
    public boolean hasPermission(ICommandSource sender, String permission) {
        if (sender instanceof PlayerEntity) {
            return PermissionAPI.hasPermission((PlayerEntity)((PlayerEntity)sender), (String)permission);
        }
        return true;
    }

    public Stream<ForgeCommandSender> getSendersWithPermission(String permission) {
        return Stream.concat(this.server.func_184103_al().func_181057_v().stream().filter(player -> this.hasPermission((ICommandSource)player, permission)), Stream.of(this.server)).map(sender -> new ForgeCommandSender((ICommandSource)sender, this));
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.SERVER);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.SERVER);
    }

    @Override
    public String getCommandName() {
        return "spark";
    }
}

