/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.protobuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import me.lucko.spark.lib.protobuf.ByteOutput;
import me.lucko.spark.lib.protobuf.ByteString;
import me.lucko.spark.lib.protobuf.NioByteString;

public final class UnsafeByteOperations {
    private UnsafeByteOperations() {
    }

    public static ByteString unsafeWrap(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset();
            return ByteString.wrap(buffer.array(), offset + buffer.position(), buffer.remaining());
        }
        return new NioByteString(buffer);
    }

    public static void unsafeWriteTo(ByteString bytes, ByteOutput output) throws IOException {
        bytes.writeTo(output);
    }
}

