/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.text;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.spark.lib.text.BuildableComponent;
import me.lucko.spark.lib.text.ComponentBuilder;
import me.lucko.spark.lib.text.KeybindComponentImpl;
import me.lucko.spark.lib.text.ScopedComponent;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface KeybindComponent
extends BuildableComponent<KeybindComponent, Builder>,
ScopedComponent<KeybindComponent> {
    public static @NonNull Builder builder() {
        return new KeybindComponentImpl.BuilderImpl();
    }

    public static @NonNull Builder builder(@NonNull String keybind) {
        return KeybindComponent.builder().keybind(keybind);
    }

    public static @NonNull KeybindComponent of(@NonNull String keybind) {
        return (KeybindComponent)KeybindComponent.builder(keybind).build();
    }

    public static @NonNull KeybindComponent of(@NonNull String keybind, @Nullable TextColor color) {
        return KeybindComponent.of(keybind, color, Collections.emptySet());
    }

    public static @NonNull KeybindComponent of(@NonNull String content, @Nullable TextColor color, TextDecoration ... decorations) {
        HashSet<TextDecoration> activeDecorations = new HashSet<TextDecoration>(decorations.length);
        Collections.addAll(activeDecorations, decorations);
        return KeybindComponent.of(content, color, activeDecorations);
    }

    public static @NonNull KeybindComponent of(@NonNull String keybind, @Nullable TextColor color, @NonNull Set<TextDecoration> decorations) {
        return (KeybindComponent)((Builder)((Builder)KeybindComponent.builder(keybind).color(color)).decorations(decorations, true)).build();
    }

    public static @NonNull KeybindComponent make(@NonNull Consumer<? super Builder> consumer) {
        Builder builder = KeybindComponent.builder();
        consumer.accept(builder);
        return (KeybindComponent)builder.build();
    }

    public static @NonNull KeybindComponent make(@NonNull String keybind, @NonNull Consumer<? super Builder> consumer) {
        Builder builder = KeybindComponent.builder(keybind);
        consumer.accept(builder);
        return (KeybindComponent)builder.build();
    }

    public @NonNull String keybind();

    public @NonNull KeybindComponent keybind(@NonNull String var1);

    public static interface Builder
    extends ComponentBuilder<KeybindComponent, Builder> {
        public @NonNull Builder keybind(@NonNull String var1);
    }
}

