/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.text.format;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.event.ClickEvent;
import me.lucko.spark.lib.text.event.HoverEvent;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;
import me.lucko.spark.lib.text.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Style {
    private static final Style EMPTY = new Style(null, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, TextDecoration.State.NOT_SET, null, null, null);
    private final @Nullable TextColor color;
    private final TextDecoration.State obfuscated;
    private final TextDecoration.State bold;
    private final TextDecoration.State strikethrough;
    private final TextDecoration.State underlined;
    private final TextDecoration.State italic;
    private final @Nullable ClickEvent clickEvent;
    private final @Nullable HoverEvent hoverEvent;
    private final @Nullable String insertion;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull Style empty() {
        return EMPTY;
    }

    public static @NonNull Style of(@Nullable TextColor color) {
        return Style.builder().color(color).build();
    }

    public static @NonNull Style of(TextDecoration ... decorations) {
        Builder builder = Style.builder();
        for (TextDecoration decoration : decorations) {
            builder.decoration(decoration, true);
        }
        return builder.build();
    }

    public static @NonNull Style of(@Nullable TextColor color, TextDecoration ... decorations) {
        Builder builder = Style.builder();
        builder.color(color);
        for (TextDecoration decoration : decorations) {
            builder.decoration(decoration, true);
        }
        return builder.build();
    }

    private Style(@Nullable TextColor color, TextDecoration.State obfuscated, TextDecoration.State bold, TextDecoration.State strikethrough, TextDecoration.State underlined, TextDecoration.State italic, @Nullable ClickEvent clickEvent, @Nullable HoverEvent hoverEvent, @Nullable String insertion) {
        this.color = color;
        this.obfuscated = obfuscated;
        this.bold = bold;
        this.strikethrough = strikethrough;
        this.underlined = underlined;
        this.italic = italic;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
        this.insertion = insertion;
    }

    public @Nullable TextColor color() {
        return this.color;
    }

    public @NonNull Style colorIfAbsent(@Nullable TextColor color) {
        if (this.color == null) {
            return this.color(color);
        }
        return this;
    }

    public @NonNull Style color(@Nullable TextColor color) {
        return new Style(color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public boolean hasDecoration(@NonNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NonNull TextDecoration.State decoration(@NonNull TextDecoration decoration) {
        switch (decoration) {
            case BOLD: {
                return this.bold;
            }
            case ITALIC: {
                return this.italic;
            }
            case UNDERLINED: {
                return this.underlined;
            }
            case STRIKETHROUGH: {
                return this.strikethrough;
            }
            case OBFUSCATED: {
                return this.obfuscated;
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    public @NonNull Style decoration(@NonNull TextDecoration decoration, boolean flag) {
        return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
    }

    public @NonNull Style decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        switch (decoration) {
            case BOLD: {
                return new Style(this.color, this.obfuscated, Objects.requireNonNull(state, "flag"), this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
            }
            case ITALIC: {
                return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, Objects.requireNonNull(state, "flag"), this.clickEvent, this.hoverEvent, this.insertion);
            }
            case UNDERLINED: {
                return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, Objects.requireNonNull(state, "flag"), this.italic, this.clickEvent, this.hoverEvent, this.insertion);
            }
            case STRIKETHROUGH: {
                return new Style(this.color, this.obfuscated, this.bold, Objects.requireNonNull(state, "flag"), this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
            }
            case OBFUSCATED: {
                return new Style(this.color, Objects.requireNonNull(state, "flag"), this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
            }
        }
        throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
    }

    public @NonNull Set<TextDecoration> decorations() {
        return this.decorations(Collections.emptySet());
    }

    public @NonNull Set<TextDecoration> decorations(@NonNull Set<TextDecoration> defaultValues) {
        EnumSet<TextDecoration> decorations = EnumSet.noneOf(TextDecoration.class);
        for (TextDecoration decoration : TextDecoration.values()) {
            TextDecoration.State value = this.decoration(decoration);
            if (value != TextDecoration.State.TRUE && (value != TextDecoration.State.NOT_SET || !defaultValues.contains(decoration))) continue;
            decorations.add(decoration);
        }
        return decorations;
    }

    public @Nullable ClickEvent clickEvent() {
        return this.clickEvent;
    }

    public @NonNull Style clickEvent(@Nullable ClickEvent event) {
        return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, event, this.hoverEvent, this.insertion);
    }

    public @Nullable HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    public @NonNull Style hoverEvent(@Nullable HoverEvent event) {
        return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, event, this.insertion);
    }

    public @Nullable String insertion() {
        return this.insertion;
    }

    public @NonNull Style insertion(@Nullable String insertion) {
        return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, insertion);
    }

    public @NonNull Style mergeColor(@NonNull Style that) {
        return new Style(that.color(), this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public @NonNull Style mergeDecorations(@NonNull Style that) {
        TextDecoration.State obfuscated = that.decoration(TextDecoration.OBFUSCATED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.OBFUSCATED) : this.obfuscated;
        TextDecoration.State bold = that.decoration(TextDecoration.BOLD) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.BOLD) : this.bold;
        TextDecoration.State strikethrough = that.decoration(TextDecoration.STRIKETHROUGH) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.STRIKETHROUGH) : this.strikethrough;
        TextDecoration.State underlined = that.decoration(TextDecoration.UNDERLINED) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.UNDERLINED) : this.underlined;
        TextDecoration.State italic = that.decoration(TextDecoration.ITALIC) != TextDecoration.State.NOT_SET ? that.decoration(TextDecoration.ITALIC) : this.italic;
        return new Style(this.color, obfuscated, bold, strikethrough, underlined, italic, this.clickEvent, this.hoverEvent, this.insertion);
    }

    public @NonNull Style mergeEvents(@NonNull Style that) {
        return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, that.clickEvent(), that.hoverEvent(), this.insertion);
    }

    public boolean isEmpty() {
        return this.color == null && this.obfuscated == TextDecoration.State.NOT_SET && this.bold == TextDecoration.State.NOT_SET && this.strikethrough == TextDecoration.State.NOT_SET && this.underlined == TextDecoration.State.NOT_SET && this.italic == TextDecoration.State.NOT_SET && this.clickEvent == null && this.hoverEvent == null && this.insertion == null;
    }

    public @NonNull Builder toBuilder() {
        return new Builder(this);
    }

    public @NonNull String toString() {
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        builder.put("color", this.color);
        builder.put("obfuscated", (Object)this.obfuscated);
        builder.put("bold", (Object)this.bold);
        builder.put("strikethrough", (Object)this.strikethrough);
        builder.put("underlined", (Object)this.underlined);
        builder.put("italic", (Object)this.italic);
        builder.put("clickEvent", this.clickEvent);
        builder.put("hoverEvent", this.hoverEvent);
        builder.put("insertion", this.insertion);
        return ToStringer.toString(this, builder);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Style)) {
            return false;
        }
        Style that = (Style)other;
        return this.color == that.color && Objects.equals((Object)this.obfuscated, (Object)that.obfuscated) && Objects.equals((Object)this.bold, (Object)that.bold) && Objects.equals((Object)this.strikethrough, (Object)that.strikethrough) && Objects.equals((Object)this.underlined, (Object)that.underlined) && Objects.equals((Object)this.italic, (Object)that.italic) && Objects.equals(this.clickEvent, that.clickEvent) && Objects.equals(this.hoverEvent, that.hoverEvent) && Objects.equals(this.insertion, that.insertion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion});
    }

    public static class Builder {
        private @Nullable TextColor color;
        private TextDecoration.State obfuscated = TextDecoration.State.NOT_SET;
        private TextDecoration.State bold = TextDecoration.State.NOT_SET;
        private TextDecoration.State strikethrough = TextDecoration.State.NOT_SET;
        private TextDecoration.State underlined = TextDecoration.State.NOT_SET;
        private TextDecoration.State italic = TextDecoration.State.NOT_SET;
        private @Nullable ClickEvent clickEvent;
        private @Nullable HoverEvent hoverEvent;
        private @Nullable String insertion;

        protected Builder() {
        }

        protected Builder(@NonNull Component component) {
            this(component.style());
        }

        protected Builder(@NonNull Style style) {
            this.color = style.color();
            this.obfuscated = style.decoration(TextDecoration.OBFUSCATED);
            this.bold = style.decoration(TextDecoration.BOLD);
            this.strikethrough = style.decoration(TextDecoration.STRIKETHROUGH);
            this.underlined = style.decoration(TextDecoration.UNDERLINED);
            this.italic = style.decoration(TextDecoration.ITALIC);
            this.clickEvent = style.clickEvent();
            this.hoverEvent = style.hoverEvent();
            this.insertion = style.insertion();
        }

        public @NonNull Builder color(@Nullable TextColor color) {
            this.color = color;
            return this;
        }

        public @NonNull Builder colorIfAbsent(@Nullable TextColor color) {
            if (this.color == null) {
                this.color = color;
            }
            return this;
        }

        public @NonNull Builder decoration(@NonNull TextDecoration decoration, boolean flag) {
            return this.decoration(decoration, TextDecoration.State.byBoolean(flag));
        }

        public @NonNull Builder decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
            switch (decoration) {
                case BOLD: {
                    this.bold = Objects.requireNonNull(state, "flag");
                    return this;
                }
                case ITALIC: {
                    this.italic = Objects.requireNonNull(state, "flag");
                    return this;
                }
                case UNDERLINED: {
                    this.underlined = Objects.requireNonNull(state, "flag");
                    return this;
                }
                case STRIKETHROUGH: {
                    this.strikethrough = Objects.requireNonNull(state, "flag");
                    return this;
                }
                case OBFUSCATED: {
                    this.obfuscated = Objects.requireNonNull(state, "flag");
                    return this;
                }
            }
            throw new IllegalArgumentException(String.format("unknown decoration '%s'", decoration));
        }

        public @NonNull Builder clickEvent(@Nullable ClickEvent event) {
            this.clickEvent = event;
            return this;
        }

        public @NonNull Builder hoverEvent(@Nullable HoverEvent event) {
            this.hoverEvent = event;
            return this;
        }

        public @NonNull Builder insertion(@Nullable String insertion) {
            this.insertion = insertion;
            return this;
        }

        public @NonNull Style build() {
            return new Style(this.color, this.obfuscated, this.bold, this.strikethrough, this.underlined, this.italic, this.clickEvent, this.hoverEvent, this.insertion);
        }
    }
}

