/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.text.serializer.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import me.lucko.spark.lib.text.BlockNbtComponent;
import me.lucko.spark.lib.text.BuildableComponent;
import me.lucko.spark.lib.text.Component;
import me.lucko.spark.lib.text.ComponentBuilder;
import me.lucko.spark.lib.text.EntityNbtComponent;
import me.lucko.spark.lib.text.KeybindComponent;
import me.lucko.spark.lib.text.NbtComponent;
import me.lucko.spark.lib.text.ScoreComponent;
import me.lucko.spark.lib.text.SelectorComponent;
import me.lucko.spark.lib.text.TextComponent;
import me.lucko.spark.lib.text.TranslatableComponent;
import me.lucko.spark.lib.text.event.ClickEvent;
import me.lucko.spark.lib.text.event.HoverEvent;
import me.lucko.spark.lib.text.format.Style;
import me.lucko.spark.lib.text.format.TextColor;
import me.lucko.spark.lib.text.format.TextDecoration;
import me.lucko.spark.lib.text.serializer.ComponentSerializer;
import me.lucko.spark.lib.text.serializer.gson.BlockNbtComponentPosSerializer;
import me.lucko.spark.lib.text.serializer.gson.NameMapSerializer;
import me.lucko.spark.lib.text.serializer.gson.StyleSerializer;
import me.lucko.spark.lib.text.serializer.gson.TextColorWrapper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonComponentSerializer
implements ComponentSerializer<Component, Component, String>,
JsonDeserializer<Component>,
JsonSerializer<Component> {
    public static final GsonComponentSerializer INSTANCE = new GsonComponentSerializer();
    static final Gson GSON = GsonComponentSerializer.populate(new GsonBuilder()).create();
    static final String TEXT = "text";
    static final String TRANSLATE = "translate";
    static final String TRANSLATE_WITH = "with";
    static final String SCORE = "score";
    static final String SCORE_NAME = "name";
    static final String SCORE_OBJECTIVE = "objective";
    static final String SCORE_VALUE = "value";
    static final String SELECTOR = "selector";
    static final String KEYBIND = "keybind";
    static final String EXTRA = "extra";
    static final String NBT = "nbt";
    static final String NBT_INTERPRET = "interpret";
    static final String NBT_BLOCK = "block";
    static final String NBT_ENTITY = "entity";

    public static @NonNull GsonBuilder populate(@NonNull GsonBuilder builder) {
        builder.registerTypeHierarchyAdapter(Component.class, (Object)INSTANCE).registerTypeAdapter(Style.class, (Object)StyleSerializer.INSTANCE).registerTypeAdapter(ClickEvent.Action.class, new NameMapSerializer<ClickEvent.Action>("click action", ClickEvent.Action.NAMES)).registerTypeAdapter(HoverEvent.Action.class, new NameMapSerializer<HoverEvent.Action>("hover action", HoverEvent.Action.NAMES)).registerTypeAdapter(TextColorWrapper.class, (Object)new TextColorWrapper.Serializer()).registerTypeAdapter(TextColor.class, new NameMapSerializer<TextColor>("text color", TextColor.NAMES)).registerTypeAdapter(TextDecoration.class, new NameMapSerializer<TextDecoration>("text decoration", TextDecoration.NAMES)).registerTypeHierarchyAdapter(BlockNbtComponent.Pos.class, (Object)BlockNbtComponentPosSerializer.INSTANCE);
        return builder;
    }

    @Override
    public @NonNull Component deserialize(@NonNull String string) {
        return (Component)GSON.fromJson(string, Component.class);
    }

    @Override
    public @NonNull String serialize(@NonNull Component component) {
        return GSON.toJson((Object)component);
    }

    @Deprecated
    public Component deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize0(json, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BuildableComponent<?, ?> deserialize0(JsonElement element, JsonDeserializationContext context) throws JsonParseException {
        Style style;
        ComponentBuilder<TextComponent, TextComponent.Builder> component;
        if (element.isJsonPrimitive()) {
            return TextComponent.of(element.getAsString());
        }
        if (element.isJsonArray()) {
            void var3_4;
            Object var3_3 = null;
            for (JsonElement childElement : element.getAsJsonArray()) {
                BuildableComponent<?, ?> child = this.deserialize0(childElement, context);
                if (var3_4 == null) {
                    Object obj = child.toBuilder();
                    continue;
                }
                var3_4.append(child);
            }
            if (var3_4 != null) return var3_4.build();
            throw new JsonParseException("Don't know how to turn " + element + " into a Component");
        }
        if (!element.isJsonObject()) {
            throw new JsonParseException("Don't know how to turn " + element + " into a Component");
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has(TEXT)) {
            component = TextComponent.builder(jsonObject.get(TEXT).getAsString());
        } else if (jsonObject.has(TRANSLATE)) {
            String key = jsonObject.get(TRANSLATE).getAsString();
            if (!jsonObject.has(TRANSLATE_WITH)) {
                component = TranslatableComponent.builder(key);
            } else {
                JsonArray with = jsonObject.getAsJsonArray(TRANSLATE_WITH);
                ArrayList args = new ArrayList(with.size());
                int size = with.size();
                for (int i = 0; i < size; ++i) {
                    JsonElement argElement = with.get(i);
                    args.add(this.deserialize0(argElement, context));
                }
                component = TranslatableComponent.builder(key).args(args);
            }
        } else if (jsonObject.has(SCORE)) {
            JsonObject score = jsonObject.getAsJsonObject(SCORE);
            if (!score.has(SCORE_NAME) || !score.has(SCORE_OBJECTIVE)) {
                throw new JsonParseException("A score component requires a name and objective");
            }
            component = score.has(SCORE_VALUE) ? ScoreComponent.builder().name(score.get(SCORE_NAME).getAsString()).objective(score.get(SCORE_OBJECTIVE).getAsString()).value(score.get(SCORE_VALUE).getAsString()) : ScoreComponent.builder().name(score.get(SCORE_NAME).getAsString()).objective(score.get(SCORE_OBJECTIVE).getAsString());
        } else if (jsonObject.has(SELECTOR)) {
            component = SelectorComponent.builder().pattern(jsonObject.get(SELECTOR).getAsString());
        } else if (jsonObject.has(KEYBIND)) {
            component = KeybindComponent.builder().keybind(jsonObject.get(KEYBIND).getAsString());
        } else {
            boolean interpret;
            if (!jsonObject.has(NBT)) throw GsonComponentSerializer.notSureHowToDeserialize(element);
            String nbt = jsonObject.get(NBT).getAsString();
            boolean bl = interpret = jsonObject.has(NBT_INTERPRET) && jsonObject.getAsJsonPrimitive(NBT_INTERPRET).getAsBoolean();
            if (jsonObject.has(NBT_BLOCK)) {
                BlockNbtComponent.Pos position = (BlockNbtComponent.Pos)context.deserialize(jsonObject.get(NBT_BLOCK), BlockNbtComponent.Pos.class);
                component = ((BlockNbtComponent.Builder)((BlockNbtComponent.Builder)BlockNbtComponent.builder().nbtPath(nbt)).interpret(interpret)).pos(position);
            } else {
                if (!jsonObject.has(NBT_ENTITY)) throw GsonComponentSerializer.notSureHowToDeserialize(element);
                component = ((EntityNbtComponent.Builder)((EntityNbtComponent.Builder)EntityNbtComponent.builder().nbtPath(nbt)).interpret(interpret)).selector(jsonObject.get(NBT_ENTITY).getAsString());
            }
        }
        if (jsonObject.has(EXTRA)) {
            JsonArray extra = jsonObject.getAsJsonArray(EXTRA);
            int size = extra.size();
            for (int i = 0; i < size; ++i) {
                JsonElement extraElement = extra.get(i);
                component.append(this.deserialize0(extraElement, context));
            }
        }
        if ((style = (Style)context.deserialize(element, Style.class)).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public JsonElement serialize(Component src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement style;
        JsonObject object = new JsonObject();
        if (src instanceof TextComponent) {
            object.addProperty(TEXT, ((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            object.addProperty(TRANSLATE, tc.key());
            if (!tc.args().isEmpty()) {
                JsonArray with = new JsonArray();
                for (Component arg : tc.args()) {
                    with.add(context.serialize((Object)arg));
                }
                object.add(TRANSLATE_WITH, (JsonElement)with);
            }
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            JsonObject score = new JsonObject();
            score.addProperty(SCORE_NAME, sc.name());
            score.addProperty(SCORE_OBJECTIVE, sc.objective());
            if (sc.value() != null) {
                score.addProperty(SCORE_VALUE, sc.value());
            }
            object.add(SCORE, (JsonElement)score);
        } else if (src instanceof SelectorComponent) {
            object.addProperty(SELECTOR, ((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            object.addProperty(KEYBIND, ((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NbtComponent)) throw GsonComponentSerializer.notSureHowToSerialize(src);
            NbtComponent nc = (NbtComponent)src;
            object.addProperty(NBT, nc.nbtPath());
            object.addProperty(NBT_INTERPRET, Boolean.valueOf(nc.interpret()));
            if (src instanceof BlockNbtComponent) {
                JsonElement position = context.serialize((Object)((BlockNbtComponent)nc).pos());
                object.add(NBT_BLOCK, position);
            } else {
                if (!(src instanceof EntityNbtComponent)) throw GsonComponentSerializer.notSureHowToSerialize(src);
                object.addProperty(NBT_ENTITY, ((EntityNbtComponent)nc).selector());
            }
        }
        if (!src.children().isEmpty()) {
            JsonArray extra = new JsonArray();
            for (Component child : src.children()) {
                extra.add(context.serialize((Object)child));
            }
            object.add(EXTRA, (JsonElement)extra);
        }
        if (!src.hasStyling() || !(style = context.serialize((Object)src.style())).isJsonObject()) return object;
        for (Map.Entry entry : ((JsonObject)style).entrySet()) {
            object.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return object;
    }

    private static JsonParseException notSureHowToDeserialize(JsonElement element) {
        return new JsonParseException("Don't know how to turn " + element + " into a Component");
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
    }
}

