/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.Collections2;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolCommandsRegistration;
import com.sk89q.worldedit.command.tool.BlockDataCyler;
import com.sk89q.worldedit.command.tool.BlockReplacer;
import com.sk89q.worldedit.command.tool.DistanceWand;
import com.sk89q.worldedit.command.tool.FloatingTreeRemover;
import com.sk89q.worldedit.command.tool.FloodFillTool;
import com.sk89q.worldedit.command.tool.InvalidToolBindException;
import com.sk89q.worldedit.command.tool.LongRangeBuildTool;
import com.sk89q.worldedit.command.tool.NavigationWand;
import com.sk89q.worldedit.command.tool.QueryTool;
import com.sk89q.worldedit.command.tool.SelectionWand;
import com.sk89q.worldedit.command.tool.TreePlanter;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.CommandMetadata;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.part.SubCommandPart;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class ToolCommands {
    private final WorldEdit we;

    public static void register(CommandRegistrationHandler registration, CommandManager commandManager, CommandManagerService commandManagerService, WorldEdit worldEdit) {
        CommandManager collect = commandManagerService.newCommandManager();
        registration.register(collect, ToolCommandsRegistration.builder(), new ToolCommands(worldEdit));
        Set commands = collect.getAllCommands().collect(Collectors.toSet());
        for (org.enginehub.piston.Command command2 : commands) {
            if (command2.getAliases().contains((Object)"unbind")) {
                command2 = command2.toBuilder().aliases(Collections2.filter(command2.getAliases(), alias -> !"unbind".equals(alias))).build();
            }
            commandManager.register(CommandUtil.deprecate(command2, "Global tool names cause conflicts and will be removed in WorldEdit 8", ToolCommands::asNonGlobal));
        }
        Set nonGlobalCommands = commands.stream().map(command -> command.toBuilder().aliases(Collections2.filter(command.getAliases(), alias -> !alias.startsWith("/"))).build()).collect(Collectors.toSet());
        commandManager.register("tool", command -> {
            command.addPart(SubCommandPart.builder(TranslatableComponent.of("tool"), TextComponent.of("The tool to bind")).withCommands(nonGlobalCommands).required().build());
            command.description(TextComponent.of("Binds a tool to the item in your hand"));
        });
    }

    private static String asNonGlobal(org.enginehub.piston.Command oldCommand, CommandParameters oldParameters) {
        String name = Optional.ofNullable(oldParameters.getMetadata()).map(CommandMetadata::getCalledName).filter(n -> !n.startsWith("/")).orElseGet(oldCommand::getName);
        return "/tool " + name;
    }

    static void setToolNone(Player player, LocalSession session, boolean isBrush) throws InvalidToolBindException {
        session.setTool(player.getItemInHand(HandSide.MAIN_HAND).getType(), null);
        player.printInfo(TranslatableComponent.of(isBrush ? "worldedit.brush.none.equip" : "worldedit.tool.none.equip"));
    }

    public ToolCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="none", aliases={"unbind"}, desc="Unbind a bound tool from your current item")
    public void none(Player player, LocalSession session) throws WorldEditException {
        ToolCommands.setToolNone(player, session, false);
    }

    @Command(name="selwand", aliases={"/selwand"}, desc="Selection wand tool")
    @CommandPermissions(value={"worldedit.setwand"})
    public void selwand(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new SelectionWand());
        player.printInfo(TranslatableComponent.of("worldedit.tool.selwand.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="navwand", aliases={"/navwand"}, desc="Navigation wand tool")
    @CommandPermissions(value={"worldedit.setwand"})
    public void navwand(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new NavigationWand());
        player.printInfo(TranslatableComponent.of("worldedit.tool.navWand.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="info", desc="Block information tool")
    @CommandPermissions(value={"worldedit.tool.info"})
    public void info(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new QueryTool());
        player.printInfo(TranslatableComponent.of("worldedit.tool.info.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="tree", desc="Tree generator tool")
    @CommandPermissions(value={"worldedit.tool.tree"})
    public void tree(Player player, LocalSession session, @Arg(desc="Type of tree to generate", def={"tree"}) TreeGenerator.TreeType type) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new TreePlanter(type));
        player.printInfo(TranslatableComponent.of("worldedit.tool.tree.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="repl", desc="Block replacer tool")
    @CommandPermissions(value={"worldedit.tool.replacer"})
    public void repl(Player player, LocalSession session, @Arg(desc="The pattern of blocks to place") Pattern pattern) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new BlockReplacer(pattern));
        player.printInfo(TranslatableComponent.of("worldedit.tool.repl.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="cycler", desc="Block data cycler tool")
    @CommandPermissions(value={"worldedit.tool.data-cycler"})
    public void cycler(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new BlockDataCyler());
        player.printInfo(TranslatableComponent.of("worldedit.tool.data-cycler.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="floodfill", aliases={"flood"}, desc="Flood fill tool")
    @CommandPermissions(value={"worldedit.tool.flood-fill"})
    public void floodFill(Player player, LocalSession session, @Arg(desc="The pattern to flood fill") Pattern pattern, @Arg(desc="The range to perform the fill") int range) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (range > config.maxSuperPickaxeSize) {
            player.printError(TranslatableComponent.of("worldedit.superpickaxe.max-range", TextComponent.of(config.maxSuperPickaxeSize)));
            return;
        }
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new FloodFillTool(range, pattern));
        player.printInfo(TranslatableComponent.of("worldedit.tool.floodfill.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="deltree", desc="Floating tree remover tool")
    @CommandPermissions(value={"worldedit.tool.deltree"})
    public void deltree(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new FloatingTreeRemover());
        player.printInfo(TranslatableComponent.of("worldedit.tool.deltree.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="farwand", desc="Wand at a distance tool")
    @CommandPermissions(value={"worldedit.tool.farwand"})
    public void farwand(Player player, LocalSession session) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new DistanceWand());
        player.printInfo(TranslatableComponent.of("worldedit.tool.farwand.equip", TextComponent.of(itemType.getName())));
    }

    @Command(name="lrbuild", aliases={"/lrbuild"}, desc="Long-range building tool")
    @CommandPermissions(value={"worldedit.tool.lrbuild"})
    public void longrangebuildtool(Player player, LocalSession session, @Arg(desc="Pattern to set on left-click") Pattern primary, @Arg(desc="Pattern to set on right-click") Pattern secondary) throws WorldEditException {
        ItemType itemType = player.getItemInHand(HandSide.MAIN_HAND).getType();
        session.setTool(itemType, new LongRangeBuildTool(primary, secondary));
        player.printInfo(TranslatableComponent.of("worldedit.tool.lrbuild.equip", TextComponent.of(itemType.getName())));
        String primaryName = "pattern";
        String secondaryName = "pattern";
        if (primary instanceof BlockStateHolder) {
            primaryName = ((BlockStateHolder)primary).getBlockType().getName();
        }
        if (secondary instanceof BlockStateHolder) {
            secondaryName = ((BlockStateHolder)secondary).getBlockType().getName();
        }
        player.printInfo(TranslatableComponent.of("worldedit.tool.lrbuild.set", TextComponent.of(primaryName), TextComponent.of(secondaryName)));
    }
}

