/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io.legacycompat;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Map;

public class NoteBlockCompatibilityHandler
implements NBTCompatibilityHandler {
    private static final IntegerProperty NoteProperty;

    @Override
    public <B extends BlockStateHolder<B>> boolean isAffectedBlock(B block) {
        return NoteProperty != null && block.getBlockType() == BlockTypes.NOTE_BLOCK;
    }

    @Override
    public <B extends BlockStateHolder<B>> B updateNBT(B block, Map<String, Tag> values) {
        Byte note;
        Tag noteTag = values.get("note");
        if (noteTag instanceof ByteTag && (note = ((ByteTag)noteTag).getValue()) != null) {
            values.clear();
            return (B)block.with(NoteProperty, (int)note).toImmutableState();
        }
        return block;
    }

    static {
        IntegerProperty temp;
        try {
            temp = (IntegerProperty)BlockTypes.NOTE_BLOCK.getProperty("note");
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException e) {
            temp = null;
        }
        NoteProperty = temp;
    }
}

