/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.google.common.collect.AbstractIterator;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.collection.PositionList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;

class VectorPositionList
implements PositionList {
    private final IntList delegate = new IntArrayList();

    VectorPositionList() {
    }

    @Override
    public BlockVector3 get(int index) {
        int ri = index * 3;
        return BlockVector3.at(this.delegate.getInt(ri), this.delegate.getInt(ri + 1), this.delegate.getInt(ri + 2));
    }

    @Override
    public void add(BlockVector3 vector) {
        this.delegate.add(vector.getX());
        this.delegate.add(vector.getY());
        this.delegate.add(vector.getZ());
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Iterator<BlockVector3> iterator() {
        return new AbstractIterator<BlockVector3>(){
            private final IntIterator iterator;
            {
                this.iterator = VectorPositionList.this.delegate.iterator();
            }

            protected BlockVector3 computeNext() {
                if (!this.iterator.hasNext()) {
                    return (BlockVector3)this.endOfData();
                }
                return BlockVector3.at(this.iterator.nextInt(), this.iterator.nextInt(), this.iterator.nextInt());
            }
        };
    }

    @Override
    public Iterator<BlockVector3> reverseIterator() {
        return new AbstractIterator<BlockVector3>(){
            private final IntListIterator iterator;
            {
                this.iterator = VectorPositionList.this.delegate.listIterator(VectorPositionList.this.delegate.size());
            }

            protected BlockVector3 computeNext() {
                if (!this.iterator.hasPrevious()) {
                    return (BlockVector3)this.endOfData();
                }
                return BlockVector3.at(this.iterator.previousInt(), this.iterator.previousInt(), this.iterator.previousInt());
            }
        };
    }
}

