/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.snapshot.experimental.fs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.UrlEscapers;
import com.sk89q.worldedit.slf4j.Logger;
import com.sk89q.worldedit.slf4j.LoggerFactory;
import com.sk89q.worldedit.util.function.IORunnable;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.util.io.file.ArchiveNioSupport;
import com.sk89q.worldedit.util.io.file.MorePaths;
import com.sk89q.worldedit.util.time.FileNameDateTimeParser;
import com.sk89q.worldedit.util.time.ModificationDateTimeParser;
import com.sk89q.worldedit.util.time.SnapshotDateTimeParser;
import com.sk89q.worldedit.world.snapshot.experimental.Snapshot;
import com.sk89q.worldedit.world.snapshot.experimental.SnapshotDatabase;
import com.sk89q.worldedit.world.snapshot.experimental.SnapshotInfo;
import com.sk89q.worldedit.world.snapshot.experimental.fs.FolderSnapshot;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class FileSystemSnapshotDatabase
implements SnapshotDatabase {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemSnapshotDatabase.class);
    private static final String SCHEME = "snapfs";
    private static final List<SnapshotDateTimeParser> DATE_TIME_PARSERS = new ImmutableList.Builder().add((Object)FileNameDateTimeParser.getInstance()).addAll(ServiceLoader.load(SnapshotDateTimeParser.class)).add((Object)ModificationDateTimeParser.getInstance()).build();
    private final Path root;
    private final ArchiveNioSupport archiveNioSupport;

    public static ZonedDateTime tryParseDate(Path path) {
        return FileSystemSnapshotDatabase.tryParseDateInternal(path).orElseThrow(() -> new IllegalStateException("Could not detect date of " + path));
    }

    private static Optional<ZonedDateTime> tryParseDateInternal(Path path) {
        return DATE_TIME_PARSERS.stream().map(parser -> parser.detectDateTime(path)).filter(Objects::nonNull).findFirst();
    }

    public static URI createUri(String name) {
        return URI.create("snapfs:" + UrlEscapers.urlFragmentEscaper().escape(name));
    }

    public static FileSystemSnapshotDatabase maybeCreate(Path root, ArchiveNioSupport archiveNioSupport) throws IOException {
        Files.createDirectories(root, new FileAttribute[0]);
        return new FileSystemSnapshotDatabase(root, archiveNioSupport);
    }

    public FileSystemSnapshotDatabase(Path root, ArchiveNioSupport archiveNioSupport) {
        Preconditions.checkArgument((boolean)Files.isDirectory(root, new LinkOption[0]), (Object)"Database root is not a directory");
        this.root = root.toAbsolutePath();
        this.archiveNioSupport = archiveNioSupport;
    }

    private SnapshotInfo createSnapshotInfo(Path fullPath, Path realPath) {
        ZonedDateTime date = FileSystemSnapshotDatabase.tryParseDateInternal(fullPath).orElseGet(() -> FileSystemSnapshotDatabase.tryParseDate(realPath));
        return SnapshotInfo.create(FileSystemSnapshotDatabase.createUri(fullPath.toString()), date);
    }

    private Snapshot createSnapshot(Path fullPath, Path realPath, @Nullable IORunnable closeCallback) {
        return new FolderSnapshot(this.createSnapshotInfo(fullPath, realPath), realPath, closeCallback);
    }

    public Path getRoot() {
        return this.root;
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public Optional<Snapshot> getSnapshot(URI name) throws IOException {
        if (!name.getScheme().equals(SCHEME)) {
            return Optional.empty();
        }
        Path rawResolved = this.root.resolve(name.getSchemeSpecificPart());
        Path realPath = rawResolved.normalize();
        if (!realPath.startsWith(this.root)) {
            return Optional.empty();
        }
        Optional<Snapshot> result = this.tryRegularFileSnapshot(this.root.relativize(realPath), realPath);
        if (result.isPresent()) {
            return result;
        }
        if (!Files.isDirectory(realPath, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(this.createSnapshot(this.root.relativize(realPath), realPath, null));
    }

    private Optional<Snapshot> tryRegularFileSnapshot(Path fullPath, Path realPath) throws IOException {
        Closer closer = Closer.create();
        Path root = this.root;
        Path relative = root.relativize(realPath);
        Iterator iterator = null;
        try {
            while (true) {
                Optional<Path> newRootOpt;
                if (iterator == null) {
                    iterator = MorePaths.iterPaths(relative).iterator();
                }
                if (!iterator.hasNext()) {
                    return Optional.empty();
                }
                Path relativeNext = (Path)iterator.next();
                Path next = root.resolve(relativeNext);
                if (!Files.isRegularFile(next, new LinkOption[0]) || !(newRootOpt = this.archiveNioSupport.tryOpenAsDir(next)).isPresent()) continue;
                root = newRootOpt.get();
                if (root.getFileSystem() != FileSystems.getDefault()) {
                    closer.register(root.getFileSystem());
                }
                relative = root.resolve(relativeNext.relativize(relative).toString());
                iterator = null;
                if (Files.exists(relative, new LinkOption[0])) break;
            }
            return Optional.of(this.createSnapshot(fullPath, relative, closer::close));
        }
        catch (Throwable t) {
            throw closer.rethrowAndClose(t);
        }
    }

    @Override
    public Stream<Snapshot> getSnapshots(String worldName) throws IOException {
        return Stream.of(this.listWorldEntries(Paths.get("", new String[0]), this.root, worldName), this.listTimestampedEntries(Paths.get("", new String[0]), this.root, worldName)).flatMap(Function.identity());
    }

    private Stream<Snapshot> listWorldEntries(Path fullPath, Path root, String worldName) throws IOException {
        logger.debug("World check in: {}", (Object)root);
        return Files.list(root).flatMap(candidate -> {
            logger.debug("World trying: {}", candidate);
            String fileName = candidate.getFileName().toString();
            if (this.isSameDirectoryName(fileName, worldName)) {
                if (Files.exists(candidate.resolve("level.dat"), new LinkOption[0])) {
                    logger.debug("Direct!");
                    return Stream.of(this.createSnapshot(fullPath.resolve(fileName), (Path)candidate, null));
                }
                try {
                    return this.listTimestampedEntries(fullPath.resolve(fileName), (Path)candidate, worldName);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (Files.isRegularFile(candidate, new LinkOption[0]) && fileName.startsWith(worldName + ".")) {
                logger.debug("Archive!");
                try {
                    return this.tryRegularFileSnapshot(fullPath.resolve(fileName), (Path)candidate).map(Stream::of).orElse(null);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            logger.debug("Nothing!");
            return null;
        });
    }

    private boolean isSameDirectoryName(String fileName, String worldName) {
        if (fileName.lastIndexOf(47) == fileName.length() - 1) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return fileName.equalsIgnoreCase(worldName);
    }

    private Stream<Snapshot> listTimestampedEntries(Path fullPath, Path root, String worldName) throws IOException {
        logger.debug("Timestamp check in: {}", (Object)root);
        return Files.list(root).filter(candidate -> {
            ZonedDateTime date = FileNameDateTimeParser.getInstance().detectDateTime((Path)candidate);
            return date != null;
        }).flatMap(candidate -> {
            logger.debug("Timestamp trying: {}", candidate);
            if (Files.isDirectory(candidate, new LinkOption[0])) {
                logger.debug("Timestamped directory");
                try {
                    return this.listWorldEntries(fullPath.resolve(candidate.getFileName().toString()), (Path)candidate, worldName);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                Optional<Path> newRoot = this.archiveNioSupport.tryOpenAsDir((Path)candidate);
                if (!newRoot.isPresent()) {
                    logger.debug("Nothing!");
                    return null;
                }
                logger.debug("Timestamped archive!");
                return this.listWorldEntries(fullPath.resolve(candidate.getFileName().toString()), newRoot.get(), worldName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

