/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.piston.config;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.List;
import org.enginehub.piston.config.Config;

public class ColorConfig
extends Config<TextColor> {
    private static final ColorConfig TEXT_MODIFIER = new ColorConfig("piston.style.text.modifier", TextColor.YELLOW);
    private static final ColorConfig MAIN_TEXT = new ColorConfig("piston.style.main.text", TextColor.GOLD);
    private static final ColorConfig HELP_TEXT = new ColorConfig("piston.style.help.text", TextColor.GRAY);
    private static final ColorConfig PART_WRAPPING = new ColorConfig("piston.style.part.wrapping", TextColor.YELLOW);

    public static ColorConfig textModifier() {
        return TEXT_MODIFIER;
    }

    public static ColorConfig mainText() {
        return MAIN_TEXT;
    }

    public static ColorConfig helpText() {
        return HELP_TEXT;
    }

    public static ColorConfig partWrapping() {
        return PART_WRAPPING;
    }

    private ColorConfig(String key, TextColor color) {
        super(key, color);
    }

    @Override
    protected Config<TextColor> copyForDefault() {
        return new ColorConfig(this.getKey(), (TextColor)this.getValue());
    }

    public ColorConfig value(TextColor value) {
        super.value(value);
        return this;
    }

    public Component wrap(String text) {
        return this.wrap((List<Component>)ImmutableList.of((Object)TextComponent.of(text)));
    }

    @Override
    protected Component apply(List<Component> input) {
        TextColor color = (TextColor)this.getValue();
        switch (input.size()) {
            case 0: {
                return TextComponent.of("", color);
            }
            case 1: {
                return input.get(0).color(color);
            }
        }
        return ((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().color(color)).append(input)).build();
    }
}

