/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.mosca421.worldprotector.commands.CommandsRegister;
import fr.mosca421.worldprotector.core.Region;
import fr.mosca421.worldprotector.core.Saver;
import fr.mosca421.worldprotector.items.ItemsRegister;
import fr.mosca421.worldprotector.utils.RegionsUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="worldprotector")
public class WorldProtector {
    public static final String MODID = "worldprotector";
    public boolean enter = false;
    public String exitMessage = "";
    public String exitMessageSmall = "";

    public WorldProtector() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::isInRegion);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemsRegister.ITEMS.register(modEventBus);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        CommandsRegister.init((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
        Saver.onServerStarting(event);
    }

    @SubscribeEvent
    public void isInRegion(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            int dim = player.field_70170_p.func_201675_m().func_186058_p().func_186068_a();
            for (Region region : RegionsUtils.getHandlingRegionsFor(player.func_180425_c(), dim)) {
                if (region.getFlags().contains("enter-message")) {
                    try {
                        if (!this.enter) {
                            player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, TextComponentUtils.func_197680_a((CommandSource)player.func_195051_bN(), (ITextComponent)new StringTextComponent(region.getEnterMessageSmall().replace("&", "\u00a7")), (Entity)player, (int)0)));
                            player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, TextComponentUtils.func_197680_a((CommandSource)player.func_195051_bN(), (ITextComponent)new StringTextComponent(region.getEnterMessage().replace("&", "\u00a7")), (Entity)player, (int)0), 10, 10, 10));
                            if (region.getFlags().contains("exit-message")) {
                                this.exitMessage = region.getExitMessage();
                                this.exitMessageSmall = region.getExitMessageSmall();
                            } else {
                                region.setExitMessage("");
                                region.setExitMessageSmall("");
                                this.exitMessage = "";
                                this.exitMessageSmall = "";
                            }
                            this.enter = true;
                        }
                        return;
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                region.setEnterMessage("");
                region.setEnterMessageSmall("");
            }
            if (this.enter) {
                this.enter = false;
                if (!this.exitMessage.equals("")) {
                    try {
                        player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, TextComponentUtils.func_197680_a((CommandSource)player.func_195051_bN(), (ITextComponent)new StringTextComponent(this.exitMessageSmall.replace("&", "\u00a7")), (Entity)player, (int)0)));
                        player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, TextComponentUtils.func_197680_a((CommandSource)player.func_195051_bN(), (ITextComponent)new StringTextComponent(this.exitMessage.replace("&", "\u00a7")), (Entity)player, (int)0), 10, 10, 10));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

