/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.mosca421.worldprotector.core.FlagsList;
import fr.mosca421.worldprotector.core.Region;
import fr.mosca421.worldprotector.core.Saver;
import fr.mosca421.worldprotector.utils.FlagsUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;

public class CommandFlag {
    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"flag").requires(cs -> cs.func_197034_c(4))).executes(ctx -> CommandFlag.giveHelp((CommandSource)ctx.getSource()))).then(Commands.func_197057_a((String)"help").executes(ctx -> CommandFlag.giveHelp((CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"list").executes(ctx -> CommandFlag.giveList((CommandSource)ctx.getSource())))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"region", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"flag", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(FlagsList.VALID_FLAGS, (SuggestionsBuilder)builder)).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandFlag.add((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"region"), StringArgumentType.getString((CommandContext)ctx, (String)"flag"), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"region", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"flag", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(FlagsList.VALID_FLAGS, (SuggestionsBuilder)builder)).executes(ctx -> CommandFlag.add((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"region"), StringArgumentType.getString((CommandContext)ctx, (String)"flag"), "")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"region", (ArgumentType)StringArgumentType.word()).then(Commands.func_197056_a((String)"flag", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ISuggestionProvider.func_197005_b(FlagsList.VALID_FLAGS, (SuggestionsBuilder)builder)).executes(ctx -> CommandFlag.remove((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"region"), StringArgumentType.getString((CommandContext)ctx, (String)"flag"))))))).then(Commands.func_197057_a((String)"info").then(Commands.func_197056_a((String)"region", (ArgumentType)StringArgumentType.word()).executes(ctx -> CommandFlag.info((CommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"region")))));
    }

    private static int giveHelp(CommandSource source) {
        try {
            FlagsUtils.giveHelpMessage(source.func_197035_h());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int giveList(CommandSource source) {
        try {
            FlagsUtils.giveListFlagsOfRegion(source.func_197035_h());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int add(CommandSource source, String region, String flag, String name) {
        try {
            Region regions;
            if (flag.equalsIgnoreCase("enter-message") && Saver.REGIONS.containsKey(region)) {
                regions = Saver.REGIONS.get(region);
                regions.setEnterMessage(name);
            }
            if (flag.equalsIgnoreCase("exit-message") && Saver.REGIONS.containsKey(region)) {
                regions = Saver.REGIONS.get(region);
                regions.setExitMessage(name);
            }
            if (flag.equalsIgnoreCase("enter-message-small") && Saver.REGIONS.containsKey(region)) {
                regions = Saver.REGIONS.get(region);
                regions.setEnterMessageSmall(name);
            }
            if (flag.equalsIgnoreCase("exit-message-small") && Saver.REGIONS.containsKey(region)) {
                regions = Saver.REGIONS.get(region);
                regions.setExitMessageSmall(name);
            }
            FlagsUtils.addFlag(region, source.func_197035_h(), flag);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int remove(CommandSource source, String region, String flag) {
        try {
            FlagsUtils.removeFlag(region, source.func_197035_h(), flag);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private static int info(CommandSource source, String region) {
        try {
            FlagsUtils.getRegionFlags(region, source.func_197035_h());
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

