/*
 * Decompiled with CFR 0.152.
 */
package fr.mosca421.worldprotector.utils;

import fr.mosca421.worldprotector.items.ItemRegistryObject;
import fr.mosca421.worldprotector.utils.WrappedDeferredRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemDeferredRegister
extends WrappedDeferredRegister<Item> {
    private final List<IItemProvider> allItems = new ArrayList<IItemProvider>();

    public ItemDeferredRegister(String modid) {
        super(modid, ForgeRegistries.ITEMS);
    }

    public static Item.Properties getMekBaseProperties() {
        return new Item.Properties().func_200916_a(ItemGroup.field_78026_f);
    }

    public ItemRegistryObject<Item> register(String name) {
        return this.register(name, () -> new Item(ItemDeferredRegister.getMekBaseProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Function<Item.Properties, ITEM> sup) {
        return this.register(name, () -> (Item)sup.apply(ItemDeferredRegister.getMekBaseProperties()));
    }

    public <ITEM extends Item> ItemRegistryObject<ITEM> register(String name, Supplier<? extends ITEM> sup) {
        ItemRegistryObject registeredItem = this.register(name, sup, ItemRegistryObject::new);
        this.allItems.add(registeredItem);
        return registeredItem;
    }

    public List<IItemProvider> getAllItems() {
        return this.allItems;
    }
}

