/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.lagmeter;

import com.github.ipixeli.lagmeter.Network;
import com.github.ipixeli.lagmeter.client.Client;
import com.github.ipixeli.lagmeter.client.Config;
import com.github.ipixeli.lagmeter.server.ConfigServer;
import com.github.ipixeli.lagmeter.server.Server;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lagmeter")
public final class LagMeter {
    public static final String version = "1.3.1 (MC1.15.2)";
    public static final Logger logger = LogManager.getLogger();
    private static final Pair<Config, ForgeConfigSpec> cfg = new ForgeConfigSpec.Builder().configure(Config::new);
    private static final Pair<ConfigServer, ForgeConfigSpec> cfgServer = new ForgeConfigSpec.Builder().configure(ConfigServer::new);
    private static final String PROTOCOL_VERSION = "2";
    private static final Predicate<String> versions = v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v);
    public static final SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lagmeter:lagmeter")).clientAcceptedVersions(versions).serverAcceptedVersions(versions).networkProtocolVersion(() -> "2").simpleChannel();

    public LagMeter() {
        logger.log(Level.INFO, "LagMeter 1.3.1 (MC1.15.2)");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)cfg.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)cfgServer.getRight());
        channel.messageBuilder(Network.class, 2).decoder(Network::fromBytes).encoder(Network::toBytes).consumer(Network::onMessage).add();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverSetup);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        new Client((Config)cfg.getLeft());
    }

    @SubscribeEvent
    public void serverSetup(FMLServerStartingEvent e) {
        new Server(e.getServer(), (ConfigServer)cfgServer.getLeft());
    }

    public static class Data {
        public String n;
        public int i;

        public Data(String nIn, int iIn) {
            this.n = nIn;
            this.i = iIn;
        }
    }
}

