/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.lagmeter;

import com.github.ipixeli.lagmeter.LagMeter;
import com.github.ipixeli.lagmeter.client.Client;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class Network {
    private static int tpsOverall;
    private static ArrayList<LagMeter.Data> tpsList;

    public Network(int i, ArrayList<LagMeter.Data> l) {
        tpsOverall = i;
        tpsList = l;
    }

    public static Network fromBytes(ByteBuf buf) {
        try {
            String tpsData = buf.readCharSequence(buf.capacity() - buf.readerIndex(), Charset.forName("utf-8")).toString().trim();
            String[] dataList = tpsData.split(";");
            int tpsServer = -1;
            ArrayList<LagMeter.Data> l = new ArrayList<LagMeter.Data>();
            for (int i = 0; i < dataList.length; ++i) {
                String line = dataList[i];
                if (line.length() <= 0) continue;
                if (line.contains(",")) {
                    String[] parts = line.split(",");
                    String name = parts[0];
                    int tps = Integer.parseInt(parts[1]);
                    l.add(new LagMeter.Data(name, tps));
                    continue;
                }
                tpsServer = Integer.parseInt(line);
            }
            return new Network(tpsServer, l);
        }
        catch (Exception e) {
            LagMeter.logger.log(Level.WARN, "Invalid packet read. Error: " + e.getMessage());
            Client.lastTPSserver = -1;
            return null;
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            String data = tpsOverall + ";";
            for (LagMeter.Data p : tpsList) {
                if (p == null) continue;
                data = data + p.n + "," + p.i + ";";
            }
            buf.writeCharSequence((CharSequence)new StringBuffer(data), Charset.forName("utf-8"));
        }
        catch (Exception e) {
            LagMeter.logger.log(Level.WARN, "Failed to convert action to int. Error: " + e.getMessage());
        }
    }

    public static void onMessage(Network data, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection().equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
                Client.lastPkt = System.currentTimeMillis();
                Client.lastTPSserver = tpsOverall;
                Client.lastTPSworlds.clear();
                Client.lastTPSworlds = tpsList;
            }
        });
        context.get().setPacketHandled(true);
    }

    static {
        tpsList = new ArrayList();
    }
}

