/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.lagmeter.client;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;

public final class Config {
    protected ArrayList<ForgeConfigSpec.ConfigValue> settings = new ArrayList();
    public ForgeConfigSpec.EnumValue<CORNER> renderCorner;
    public ForgeConfigSpec.BooleanValue singleLine;
    public ForgeConfigSpec.BooleanValue tpsShown;
    public ForgeConfigSpec.IntValue tpsOutdated;
    public ForgeConfigSpec.EnumValue<TPSTYPE> tpsData;
    public ForgeConfigSpec.BooleanValue textColorDynamic;
    public ForgeConfigSpec.IntValue textColorSpecific;
    public ForgeConfigSpec.BooleanValue textShadow;
    public ForgeConfigSpec.BooleanValue textOutline;

    public Config(ForgeConfigSpec.Builder b) {
        b.comment("\n iPixeli's LagMeter Mod \n Client Configuration File \n https://www.curseforge.com/minecraft/mc-mods/lagmeter \n");
        b.push("GENERAL");
        this.renderCorner = b.comment("rendercorner: Where to display on screen.").translation("lagmeter.config.rendercorner").defineEnum("rendercorner", (Enum)CORNER.BOTTOMLEFT);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.renderCorner);
        this.singleLine = b.comment("singleline: Renders all in a single line.").translation("lagmeter.config.singleline").define("singleline", false);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.singleLine);
        b.pop();
        b.push("INFORMATION");
        this.tpsShown = b.comment("showtps: Allowed Values are true or false").translation("lagmeter.config.showtps").define("showtps", true);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.tpsShown);
        this.tpsOutdated = b.comment("tpsoutdated: How many seconds can pass before the last known TPS value is considered outdated. (Modifiable via file only)").translation("lagmeter.config.tpsoutdated").defineInRange("tpsoutdated", 10, 0, 30);
        this.tpsData = b.comment("tpsdata: What TPS data will render on screen.").translation("lagmeter.config.tpsdata").defineEnum("tpsdata", (Enum)TPSTYPE.SERVERONLY);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.tpsData);
        b.pop();
        b.push("TEXT");
        this.textColorDynamic = b.comment("textcolordynamic: Allowed Values are true or false").translation("lagmeter.config.textcolordynamic").define("textcolordynamic", true);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.textColorDynamic);
        this.textColorSpecific = b.comment("textcolorspecific: Will be ignored when textcolordynamic is enabled. Accepts hexadecimal values converted to decimal format. (Modifiable via file only)").translation("lagmeter.config.textcolorspecific").defineInRange("textcolorspecific", 0xFFFFFF, 0, 0xFFFFFF);
        this.textShadow = b.comment("textshadow: Allowed Values are true or false").translation("lagmeter.config.textshadow").define("textshadow", false);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.textShadow);
        this.textOutline = b.comment("textoutline: Allowed Values are true or false").translation("lagmeter.config.textoutline").define("textoutline", false);
        this.settings.add((ForgeConfigSpec.ConfigValue)this.textOutline);
        b.pop();
    }

    public static enum TPSTYPE {
        SERVERONLY,
        CURRENTWORLD,
        ALLWORLDS;

    }

    public static enum CORNER {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMRIGHT,
        BOTTOMLEFT;

    }
}

