/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.lagmeter.server;

import com.github.ipixeli.lagmeter.LagMeter;
import com.github.ipixeli.lagmeter.Network;
import com.github.ipixeli.lagmeter.server.ConfigServer;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.PacketDistributor;

public class Server {
    private static MinecraftServer mcs;
    private ConfigServer cfg;

    public Server(MinecraftServer s, ConfigServer c) {
        mcs = s;
        this.cfg = c;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(Server::run, 0L, ((Integer)this.cfg.updatetime.get()).intValue(), TimeUnit.SECONDS);
    }

    private static void run() {
        if (mcs.func_184103_al().func_72394_k() == 0) {
            return;
        }
        ArrayList<LagMeter.Data> list = new ArrayList<LagMeter.Data>();
        for (DimensionType dim : DimensionType.func_212681_b()) {
            long[] times = mcs.getTickTime(dim);
            if (times == null) continue;
            LagMeter.Data data = new LagMeter.Data(dim.func_186068_a() + "", (int)Server.getTPS(times));
            list.add(data);
        }
        double meanTPS = Server.getTPS(Server.mcs.field_71311_j);
        LagMeter.channel.send(PacketDistributor.ALL.noArg(), (Object)new Network((int)meanTPS, list));
    }

    private static double getTPS(long[] tickTimeArray) {
        double tickTime = (double)Server.mean(tickTimeArray) * 1.0E-6;
        double tps = Math.min(1000.0 / tickTime, 20.0);
        return tps;
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

