/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.lagremoval.main;

import com.mojang.brigadier.CommandDispatcher;
import com.swdteam.lagremoval.command.CommandBlacklistAdd;
import com.swdteam.lagremoval.command.CommandBlacklistRemove;
import com.swdteam.lagremoval.command.CommandKillAll;
import com.swdteam.lagremoval.command.CommandReloadBlacklist;
import com.swdteam.lagremoval.config.Config;
import com.swdteam.lagremoval.data.Blacklist;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

@Mod(value="lag_removal")
public class LagRemoval {
    public static AtomicBoolean RUNNING = new AtomicBoolean(true);
    private static Thread THREAD;

    public LagRemoval() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandKillAll.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandBlacklistAdd.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandBlacklistRemove.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        CommandReloadBlacklist.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        LagRemoval.startThread(event.getServer());
        try {
            Config.loadConfig();
            Blacklist.loadList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStoppingEvent event) {
        if (THREAD != null) {
            RUNNING.set(false);
        }
    }

    public static void startThread(MinecraftServer server) {
        THREAD = new Thread(() -> {
            while (RUNNING.get()) {
                if (Config.INSTANCE.show_warning) {
                    try {
                        Thread.sleep(60000 * Config.INSTANCE.auto_clear_delay - 35000);
                        server.func_213165_a(() -> LagRemoval.sendToAll(server, TextFormatting.GREEN + "[Lag Removal] Entities will be removed in 30 seconds"));
                        Thread.sleep(30000L);
                        server.func_213165_a(() -> LagRemoval.sendToAll(server, TextFormatting.GREEN + "[Lag Removal] Entities will be removed in 5 seconds"));
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Thread.sleep(60000 * Config.INSTANCE.auto_clear_delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                server.func_213165_a(() -> CommandKillAll.killAll(server));
            }
        });
        THREAD.start();
    }

    public static void sendToAll(MinecraftServer server, String msg) {
        for (int i = 0; i < server.func_184103_al().func_181057_v().size(); ++i) {
            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)server.func_184103_al().func_181057_v().get(i);
            serverplayerentity.func_146105_b((ITextComponent)new StringTextComponent(msg), true);
        }
    }
}

