/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.commands.arguments.world_pos.WorldPosArgument;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.workers.PregenWorker;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class PregenCommand {
    private static PregenWorker pregenWorker;

    public static void register(CommandDispatcher<CommandSource> dispatcher, PregenWorker _pregenWorker) {
        LiteralArgumentBuilder pregenCommand = (LiteralArgumentBuilder)Commands.func_197057_a((String)"pregen").requires(source -> source.func_197034_c(2));
        pregenCommand.then(Commands.func_197057_a((String)"list").executes(PregenCommand::printList));
        pregenCommand.then(Commands.func_197057_a((String)"start").then(Commands.func_197056_a((String)"center", (ArgumentType)WorldPosArgument.worldPos()).then(Commands.func_197056_a((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(PregenCommand::start)))));
        pregenCommand.then(Commands.func_197057_a((String)"resume").then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(PregenCommand::resume)));
        pregenCommand.then(Commands.func_197057_a((String)"pause").then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(PregenCommand::pause)));
        pregenCommand.then(Commands.func_197057_a((String)"cancel").then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(PregenCommand::cancel)));
        pregenCommand.then(Commands.func_197057_a((String)"clear").executes(PregenCommand::clear));
        pregenCommand.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"sendFeedback").executes(PregenCommand::showSendFeedback)).then(Commands.func_197056_a((String)"isFeedbackEnabled", (ArgumentType)BoolArgumentType.bool()).executes(PregenCommand::setSendFeedback)));
        dispatcher.register(pregenCommand);
        pregenWorker = _pregenWorker;
    }

    private static void printTasks(CommandSource source, ArrayList<PregenTask> tasks) {
        for (PregenTask task : tasks) {
            source.func_197030_a((ITextComponent)new StringTextComponent(String.format("%s %d %d %d", DimensionHelper.getNameOfDim(task.getDimension()), task.getCenterX(), task.getCenterZ(), task.getRadius())), false);
        }
    }

    private static int printList(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (pregenWorker.getQueue().noTasks()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Pregeneration Tasklist is empty."), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("Pregeneration Tasklist:"), false);
            ArrayList<PregenTask> activeTasks = pregenWorker.getQueue().getActiveTasks();
            ArrayList<PregenTask> pausedTasks = pregenWorker.getQueue().getPausedTasks();
            if (!activeTasks.isEmpty()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Queued Tasks:"), false);
                PregenCommand.printTasks(source, activeTasks);
            }
            if (!pausedTasks.isEmpty()) {
                source.func_197030_a((ITextComponent)new StringTextComponent("Paused Tasks:"), false);
                PregenCommand.printTasks(source, pausedTasks);
            }
        }
        return 1;
    }

    private static int start(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        WorldPos center = WorldPosArgument.getWorldPos(context, "center");
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        DimensionType dimension = DimensionArgument.func_212592_a(context, (String)"dimension");
        pregenWorker.getQueue().startTask(new PregenTask(center, radius, dimension));
        source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Task for %s got queued.", DimensionHelper.getNameOfDim(dimension))), true);
        return 1;
    }

    private static int resume(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        DimensionType dimension = DimensionArgument.func_212592_a(context, (String)"dimension");
        pregenWorker.getQueue().resumeTask(dimension);
        source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Task for %s was resumed.", DimensionHelper.getNameOfDim(dimension))), true);
        return 1;
    }

    private static int pause(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        DimensionType dimension = DimensionArgument.func_212592_a(context, (String)"dimension");
        pregenWorker.getQueue().pauseTask(dimension);
        source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Task for %s was paused.", DimensionHelper.getNameOfDim(dimension))), true);
        return 1;
    }

    private static int cancel(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        DimensionType dimension = DimensionArgument.func_212592_a(context, (String)"dimension");
        pregenWorker.getQueue().cancelTask(dimension);
        source.func_197030_a((ITextComponent)new StringTextComponent(String.format("Task for %s was canceled.", DimensionHelper.getNameOfDim(dimension))), true);
        return 1;
    }

    private static int clear(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        pregenWorker.getQueue().clear();
        source.func_197030_a((ITextComponent)new StringTextComponent("All Task were canceled."), true);
        return 1;
    }

    private static int showSendFeedback(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (ServerConfig.isSendFeedbackEnabled()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Feedback is enabled."), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("Feedback is disabled."), false);
        }
        return 1;
    }

    private static int setSendFeedback(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        ServerConfig.setSendFeedback(BoolArgumentType.getBool(context, (String)"isFeedbackEnabled"));
        if (ServerConfig.isSendFeedbackEnabled()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Feedback is now enabled."), false);
        } else {
            source.func_197030_a((ITextComponent)new StringTextComponent("Feedback is now disabled."), false);
        }
        return 1;
    }
}

