/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands.arguments.world_pos;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ILocationArgument;
import net.minecraft.command.arguments.LocationInput;
import net.minecraft.command.arguments.LocationPart;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.StringTextComponent;

public class WorldPosArgument
implements ArgumentType<ILocationArgument> {
    public static final String registry_name = "world_pos";
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "1 -5", "~1 ~-2");
    private static final SimpleCommandExceptionType WORLD_POS_INCOMPLETE = new SimpleCommandExceptionType((Message)new StringTextComponent("Incomplete (expected 2 coordinates)"));

    public static WorldPosArgument worldPos() {
        return new WorldPosArgument();
    }

    public static WorldPos getWorldPos(CommandContext<CommandSource> context, String name) {
        Vec3d vector3d = ((ILocationArgument)context.getArgument(name, ILocationArgument.class)).func_197281_a((CommandSource)context.getSource());
        return new WorldPos((int)vector3d.field_72450_a, (int)vector3d.field_72449_c);
    }

    public ILocationArgument parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        if (reader.canRead()) {
            LocationPart x = LocationPart.func_197307_a((StringReader)reader);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                LocationPart z = LocationPart.func_197307_a((StringReader)reader);
                return new LocationInput(x, new LocationPart(true, 0.0), z);
            }
            reader.setCursor(cursor);
            throw WORLD_POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
        }
        throw WORLD_POS_INCOMPLETE.createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof ISuggestionProvider) {
            String remaining = builder.getRemaining();
            Set<ISuggestionProvider.Coordinates> suggestions = !remaining.isEmpty() && remaining.charAt(0) == '^' ? Collections.singleton(ISuggestionProvider.Coordinates.field_209004_a) : ((ISuggestionProvider)context.getSource()).func_217293_r();
            return ISuggestionProvider.func_211269_a((String)remaining, suggestions, (SuggestionsBuilder)builder, (Predicate)Commands.func_212590_a(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

