/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues;

import de.geheimagentnr1.world_pre_generator.elements.queues.lists.PregenTaskList;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.helpers.SaveHelper;
import de.geheimagentnr1.world_pre_generator.save.NBTType;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;

public class PregenTaskQueue
implements Savable<CompoundNBT> {
    private static final String activeTasksName = "active_tasks";
    private static final String pausedTasksName = "paused_tasks";
    private final MinecraftServer server;
    private final PregenTaskList active_tasks = new PregenTaskList();
    private final PregenTaskList paused_tasks = new PregenTaskList();

    public PregenTaskQueue(MinecraftServer _server) {
        this.server = _server;
    }

    public synchronized Optional<PregenTask> getCurrentTask() {
        return this.active_tasks.getFirst();
    }

    public ArrayList<PregenTask> getActiveTasks() {
        return this.active_tasks.getTaskList();
    }

    public ArrayList<PregenTask> getPausedTasks() {
        return this.paused_tasks.getTaskList();
    }

    public boolean isNotEmpty() {
        return !this.active_tasks.isEmpty();
    }

    public boolean noTasks() {
        return this.active_tasks.isEmpty() && this.paused_tasks.isEmpty();
    }

    public synchronized void startTask(PregenTask new_task) {
        this.active_tasks.addOrReplace(new_task);
        this.paused_tasks.removeBy(new_task.getDimension());
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void resumeTask(DimensionType dimension) {
        this.paused_tasks.getAndRemoveBy(dimension).ifPresent(this.active_tasks::addOrReplace);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void pauseTask(DimensionType dimension) {
        this.active_tasks.getAndRemoveBy(dimension).ifPresent(this.paused_tasks::addOrReplace);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void cancelTask(DimensionType dimension) {
        this.active_tasks.runFor(dimension, (list, index) -> ((PregenTask)list.get((int)index)).cancel());
        this.paused_tasks.removeBy(dimension);
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void removeCurrentTask() {
        this.active_tasks.removeFirst();
        SaveHelper.saveWorld(this.server);
    }

    public synchronized void clearUp() {
        this.active_tasks.clear();
        this.paused_tasks.clear();
    }

    public void clear() {
        this.clearUp();
        SaveHelper.saveWorld(this.server);
    }

    @Override
    @Nonnull
    public synchronized CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(activeTasksName, (INBT)this.active_tasks.writeNBT());
        compound.func_218657_a(pausedTasksName, (INBT)this.paused_tasks.writeNBT());
        return compound;
    }

    @Override
    public synchronized void readNBT(@Nonnull CompoundNBT nbt) {
        if (nbt.func_150297_b(activeTasksName, NBTType.LIST.getId())) {
            this.active_tasks.readNBT(nbt.func_150295_c(activeTasksName, NBTType.COMPOUND.getId()));
        }
        this.paused_tasks.readNBT(nbt.func_150295_c(pausedTasksName, NBTType.COMPOUND.getId()));
    }
}

