/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.lists;

import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.save.NBTType;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.dimension.DimensionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PregenTaskList
implements Savable<ListNBT> {
    private static final Logger LOGGER = LogManager.getLogger(PregenTaskList.class);
    private final ArrayList<PregenTask> task_list = new ArrayList();

    public Optional<PregenTask> runFor(DimensionType dimension, BiConsumer<ArrayList<PregenTask>, Integer> runner) {
        for (int i = 0; i < this.task_list.size(); ++i) {
            PregenTask task = this.task_list.get(i);
            if (task.getDimension() != dimension) continue;
            runner.accept(this.task_list, i);
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public void addOrReplace(PregenTask new_task) {
        if (new_task == null) {
            return;
        }
        if (!this.runFor(new_task.getDimension(), (list, index) -> list.set((int)index, new_task)).isPresent()) {
            this.task_list.add(new_task);
        }
    }

    public ArrayList<PregenTask> getTaskList() {
        return this.task_list;
    }

    public Optional<PregenTask> getFirst() {
        return this.task_list.isEmpty() ? Optional.empty() : Optional.of(this.task_list.get(0));
    }

    public boolean isEmpty() {
        return this.task_list.isEmpty();
    }

    public Optional<PregenTask> getAndRemoveBy(DimensionType dimension) {
        return this.runFor(dimension, (list, index) -> this.task_list.remove((int)index));
    }

    public void removeFirst() {
        this.task_list.remove(0);
    }

    public void removeBy(DimensionType dimension) {
        this.runFor(dimension, (list, index) -> this.task_list.remove((int)index));
    }

    public void clear() {
        this.task_list.clear();
    }

    @Override
    @Nonnull
    public ListNBT writeNBT() {
        ListNBT nbt = new ListNBT();
        for (PregenTask task : this.task_list) {
            nbt.add((Object)task.writeNBT());
        }
        return nbt;
    }

    @Override
    public void readNBT(@Nonnull ListNBT nbt) {
        this.clear();
        for (INBT inbt : nbt) {
            if (inbt.func_74732_a() != NBTType.COMPOUND.getId()) continue;
            PregenTask task = new PregenTask();
            try {
                task.readNBT((CompoundNBT)inbt);
                this.addOrReplace(task);
            }
            catch (IllegalArgumentException exception) {
                LOGGER.error("Invalid task: Task is not added to queue.", (Throwable)exception);
            }
        }
    }
}

