/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.TimedSubTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class PrinterSubTask
extends TimedSubTask {
    private final MinecraftServer server;
    private final PregenTaskQueue queue;
    private LocalDateTime old_time;
    private int old_chunks;

    public PrinterSubTask(MinecraftServer _server, PregenTaskQueue _queue) {
        this.server = _server;
        this.queue = _queue;
    }

    @Override
    public void start() {
        super.start();
        this.old_time = LocalDateTime.now();
        this.old_chunks = 0;
    }

    @Override
    public void resume() {
        super.resume();
        this.old_time = LocalDateTime.now();
    }

    @Override
    int getDelay() {
        return ServerConfig.getPrintDelay();
    }

    @Override
    public void execute() {
        this.queue.getCurrentTask().ifPresent(task -> {
            LocalDateTime new_time = LocalDateTime.now();
            long duration = Duration.between(this.old_time, new_time).getSeconds();
            ITextComponent message = new StringTextComponent(String.format("pregen %s %d/%d(%d%%) %d chunks/s", DimensionHelper.getNameOfDim(task.getDimension()), task.getChunkIndex(), task.getChunkCount(), task.getProgress(), (long)Math.max(0, task.getChunkIndex() - this.old_chunks) / (duration == 0L ? 1L : duration))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            if (ServerConfig.isSendFeedbackEnabled()) {
                this.server.func_184103_al().func_148544_a(message, true);
            } else {
                this.server.func_145747_a(message);
            }
            this.old_time = new_time;
            this.old_chunks = task.getChunkIndex();
        });
    }
}

