/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.ThreadData;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPregenData;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import de.geheimagentnr1.world_pre_generator.save.NBTType;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.DimensionType;

public class PregenTask
implements Savable<CompoundNBT> {
    private static final String centerXName = "center_x";
    private static final String centerZName = "center_z";
    private static final String radiusName = "radius";
    private static final String chunkIndexName = "chunk_index";
    private static final String dimensionName = "dimension";
    private int center_x;
    private int center_z;
    private int radius;
    private DimensionType dimension;
    private boolean canceled = false;
    private WorldPregenData worldPregenData;
    private final ThreadData threadData = new ThreadData();

    public PregenTask(WorldPos center, int _radius, DimensionType _dimension) {
        this.center_x = center.getX();
        this.center_z = center.getZ();
        this.radius = _radius;
        this.dimension = _dimension;
        this.worldPregenData = new WorldPregenData(this.center_x, this.center_z, this.radius);
    }

    public PregenTask() {
    }

    public boolean generate(MinecraftServer server) {
        if (this.canceled) {
            return true;
        }
        if (ServerConfig.isRunParallel()) {
            if (this.threadData.getCount() < ServerConfig.getThreadCount()) {
                this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                    if (this.isNotGenerated(server, (WorldPos)currentPos)) {
                        this.threadData.incCount();
                        new Thread(() -> {
                            this.generate(server, (WorldPos)currentPos);
                            this.threadData.decCount();
                        }).start();
                    }
                });
            }
        } else {
            this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                if (this.isNotGenerated(server, (WorldPos)currentPos)) {
                    this.generate(server, (WorldPos)currentPos);
                }
            });
        }
        return this.worldPregenData.fullyGenerated();
    }

    private boolean isNotGenerated(MinecraftServer server, WorldPos pos) {
        return server.func_71218_a(this.dimension).func_72863_F().func_212849_a_(pos.getX(), pos.getZ(), ChunkStatus.field_222617_m, false) == null;
    }

    private void generate(MinecraftServer server, WorldPos pos) {
        server.func_71218_a(this.dimension).func_72863_F().func_212849_a_(pos.getX(), pos.getZ(), ChunkStatus.field_222617_m, true);
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    @Nonnull
    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a(centerXName, this.center_x);
        compound.func_74768_a(centerZName, this.center_z);
        compound.func_74768_a(radiusName, this.radius);
        compound.func_74778_a(dimensionName, DimensionHelper.getNameOfDim(this.dimension));
        compound.func_74768_a(chunkIndexName, this.getChunkIndex());
        return compound;
    }

    @Override
    public void readNBT(@Nonnull CompoundNBT nbt) {
        block8: {
            if (!nbt.func_150297_b(centerXName, NBTType.INT.getId())) {
                throw new IllegalArgumentException("Invalid center x value.");
            }
            this.center_x = nbt.func_74762_e(centerXName);
            if (!nbt.func_150297_b(centerZName, NBTType.INT.getId())) {
                throw new IllegalArgumentException("Invalid center z value.");
            }
            this.center_z = nbt.func_74762_e(centerZName);
            if (!nbt.func_150297_b(radiusName, NBTType.INT.getId())) {
                throw new IllegalArgumentException("Invalid radius value.");
            }
            this.radius = nbt.func_74762_e(radiusName);
            if (nbt.func_150297_b(dimensionName, NBTType.STRING.getId())) {
                try {
                    this.dimension = DimensionHelper.getDimFromName(nbt.func_74779_i(dimensionName));
                    if (this.dimension == null) {
                        throw new IllegalArgumentException("Dimension not found.");
                    }
                    break block8;
                }
                catch (ResourceLocationException exception) {
                    throw new IllegalArgumentException("Invalid dimension resource location.", exception);
                }
            }
            throw new IllegalArgumentException("Invalid dimension value.");
        }
        this.worldPregenData = new WorldPregenData(this.center_x, this.center_z, this.radius);
        if (!nbt.func_150297_b(chunkIndexName, NBTType.INT.getId())) {
            throw new IllegalArgumentException("Invalid chunk index value.");
        }
        this.worldPregenData.setChunkIndex(nbt.func_74762_e(chunkIndexName));
    }

    public int getCenterX() {
        return this.center_x;
    }

    public int getCenterZ() {
        return this.center_z;
    }

    public int getRadius() {
        return this.radius;
    }

    public DimensionType getDimension() {
        return this.dimension;
    }

    public int getChunkIndex() {
        return this.worldPregenData.getChunkIndex();
    }

    public int getChunkCount() {
        return this.worldPregenData.getChunkCount();
    }

    public int getProgress() {
        return this.worldPregenData.getProgess();
    }
}

