/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.workers;

import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.PrinterSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.SaverSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.Optional;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.WorldWorkerManager;

public class PregenWorker
implements WorldWorkerManager.IWorker {
    private static final PregenWorker INSTANCE = new PregenWorker();
    private MinecraftServer server;
    private PregenTaskQueue queue;
    private PrinterSubTask printer;
    private SaverSubTask saver;
    private boolean startingNewTask = true;

    public static PregenWorker getInstance() {
        return INSTANCE;
    }

    public void setServer(MinecraftServer _server) {
        this.server = _server;
        this.queue = new PregenTaskQueue(this.server);
        this.printer = new PrinterSubTask(this.server, this.queue);
        this.saver = new SaverSubTask(this.server, this.printer);
    }

    public boolean hasWork() {
        return true;
    }

    public boolean doWork() {
        Optional<PregenTask> next_task = this.queue.getCurrentTask();
        if (next_task.isPresent()) {
            PregenTask task = next_task.get();
            if (this.startingNewTask) {
                this.startingNewTask = false;
                this.server.func_184103_al().func_148544_a(new StringTextComponent(String.format("Generation of %s started.", DimensionHelper.getNameOfDim(task.getDimension()))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), true);
                this.printer.start();
                this.saver.start();
            }
            boolean finished = task.generate(this.server);
            this.printer.run();
            this.saver.run();
            if (finished) {
                this.printer.stop();
                this.saver.stop();
                this.printer.execute();
                this.server.func_184103_al().func_148544_a(new StringTextComponent(String.format("Generation of %s finished.", DimensionHelper.getNameOfDim(task.getDimension()))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), true);
                this.saver.execute();
                this.queue.removeCurrentTask();
                this.startingNewTask = true;
                return this.queue.isNotEmpty();
            }
            return true;
        }
        return false;
    }

    public PregenTaskQueue getQueue() {
        return this.queue;
    }

    public void clearUp() {
        this.queue.clearUp();
        this.startingNewTask = true;
        this.printer.stop();
        this.saver.stop();
    }
}

