/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.GustSwordProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;

public class GustSwordAbility
extends RepeaterAbility {
    public static final GustSwordAbility INSTANCE = new GustSwordAbility();

    public GustSwordAbility() {
        super("Gust Sword", AbilityHelper.getStyleCategory());
        this.setDescription("Fires a concentrated wind blast forward");
        this.setMaxCooldown(10.0);
        this.setMaxRepeaterCount(6, 3);
        this.onStartContinuityEvent = this::onStartContinuity;
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onStartContinuity(PlayerEntity player) {
        if (!ItemsHelper.isClimaTact(player.func_184614_ca())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_CLIMA_TACT, new Object[0]));
            return false;
        }
        ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
        if (climaTact.getLevel() < 3) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SORCERY_CLIMA_TACT, new Object[0]));
            return false;
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        GustSwordProjectile proj = new GustSwordProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.0f, 3.0f);
        return true;
    }
}

