/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ThunderLanceTempo
extends TempoAbility {
    public static final ThunderLanceTempo INSTANCE = new ThunderLanceTempo();
    private boolean canShoot = false;

    public ThunderLanceTempo() {
        super("Thunder Lance Tempo", AbilityHelper.getStyleCategory());
        this.setDescription("3 Charged Thunder Balls\nCreates a lighting bolt that goes directly to the area the user is pointing at, exploding on impact and hurting entities in its path");
        this.setCustomTexture("tempo");
        this.setMaxCooldown(25.0);
        this.onUseEvent = this::onUseEvent;
        this.canUseCheck = this::canUseCheck;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    public boolean canUseCheck(PlayerEntity player, TempoAbility.ICanUse check) {
        if (player.func_184614_ca().func_77973_b() instanceof ClimaTactItem) {
            ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
            String tempoCombo = climaTact.checkCharge(player.func_184614_ca());
            return tempoCombo.equalsIgnoreCase("TTT");
        }
        return false;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() instanceof ClimaTactItem) {
            ClimaTactItem climaTact = (ClimaTactItem)player.func_184614_ca().func_77973_b();
            this.setMaxCooldown((4 - climaTact.getLevel()) * 9);
            if (climaTact.getLevel() < 2) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SORCERY_CLIMA_TACT, new Object[0]));
                return false;
            }
            this.canShoot = true;
        }
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        if (player.func_184614_ca().func_77973_b() instanceof ClimaTactItem) {
            BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)player, 100.0);
            if (mop.func_216346_c().equals((Object)RayTraceResult.Type.BLOCK) && player.func_184614_ca().func_77973_b() instanceof ClimaTactItem && this.canShoot && cooldown >= 0) {
                if ((double)cooldown >= this.getMaxCooldown() * 0.67 && (double)cooldown <= this.getMaxCooldown() * 0.67 + 1.0) {
                    this.canShoot = false;
                    ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
                    int beamLength = 2;
                    LightningEntity bolt = new LightningEntity((Entity)player, beamLength + 100, 6.0f);
                    bolt.setAliveTicks(10);
                    bolt.setDamage((float)WyHelper.randomWithRange(9, 12));
                    bolt.disableLightningMimic();
                    bolt.disableExplosionKnockback();
                    bolt.setColor(new Color(253, 208, 35, 205));
                    bolt.setExplosion(1, false, 1.0f);
                    bolt.setSize(0.025f);
                    bolt.setAngle(20);
                    bolt.setBranches(2);
                    int segments = 5;
                    bolt.setSegments((int)((double)segments + WyHelper.randomWithRange(-segments / 2, segments / 2)));
                    player.field_70170_p.func_217376_c((Entity)bolt);
                }
                if (this.canShoot) {
                    double i = mop.func_216347_e().field_72450_a;
                    double j = mop.func_216347_e().field_72448_b;
                    double k = mop.func_216347_e().field_72449_c;
                    if (player.field_70173_aa % 2 == 0) {
                        this.spawn(player.field_70170_p, i, j, k, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SORCERY_CLIMA_TACT, new Object[0]));
            this.stopCooldown(player);
        }
    }

    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        GenericParticleData data;
        ParticleType<GenericParticleData> particle;
        double z;
        double y;
        double x;
        double theta;
        int i = 0;
        double phi = 0.0;
        double phi2 = 0.0;
        double radius = 2.0;
        while (phi < Math.PI) {
            phi += 2.0943951023931953;
            for (theta = 0.0; theta <= Math.PI * 2; theta += 0.7853981633974483) {
                float blue;
                float green;
                float red;
                x = radius * Math.cos(theta) * Math.sin(phi) + WyHelper.randomDouble() * radius;
                y = radius * Math.tan(theta) * Math.sin(phi) + WyHelper.randomDouble() * radius;
                z = radius * Math.sin(theta) * Math.sin(phi) + WyHelper.randomDouble() * radius;
                if (i % 2 == 0) {
                    red = 0.5f;
                    green = 0.5f;
                    blue = 0.5f;
                    particle = ModParticleTypes.MOKU2;
                } else {
                    red = 0.3f;
                    green = 0.3f;
                    blue = 0.3f;
                    particle = ModParticleTypes.MOKU;
                }
                data = new GenericParticleData(particle);
                data.setLife(25);
                data.setSize(8.0f);
                data.setColor(red, green, blue);
                WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY + y, posZ + z);
                ++i;
            }
        }
        while (phi2 < Math.PI) {
            phi2 += 2.0943951023931953;
            for (theta = 0.0; theta <= Math.PI * 2; theta += 0.7853981633974483) {
                x = radius * Math.cos(theta) * Math.sin(phi2) + WyHelper.randomDouble() * radius;
                y = radius * Math.tan(theta) * Math.sin(phi2) + WyHelper.randomDouble() * radius;
                z = radius * Math.sin(theta) * Math.sin(phi2) + WyHelper.randomDouble() * radius;
                particle = i % 4 == 0 ? ModParticleTypes.GORO_YELLOW : ModParticleTypes.GORO2_YELLOW;
                data = new GenericParticleData(particle);
                data.setLife(15);
                data.setSize(6.0f);
                WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY - 2.0 + y, posZ + z);
                ++i;
            }
        }
    }
}

