/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.particles.effects.baku.BakuMunchParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class BakuMunchAbility
extends Ability {
    public static final BakuMunchAbility INSTANCE = new BakuMunchAbility();
    public static final BlockProtectionRule GRIEF_RULE = DefaultProtectionRules.CORE_FOLIAGE_ORE;
    private static final BakuMunchParticleEffect PARTICLES = new BakuMunchParticleEffect();

    public BakuMunchAbility() {
        super("Baku Munch", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(3.0);
        this.setDescription("Allows the user to eat a big chunk of blocks in front of him, obtaining all of them as blocks in their inventory");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)player, 16.0);
        if (MathHelper.func_76133_a((double)player.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c)) < 5.0f) {
            for (int x = -2; x < 2; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        int posX = (int)mop.func_216347_e().field_72450_a + x;
                        int posY = (int)mop.func_216347_e().field_72448_b - y;
                        int posZ = (int)mop.func_216347_e().field_72449_c + z;
                        Block tempBlock = player.field_70170_p.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c();
                        if (!AbilityHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, GRIEF_RULE)) continue;
                        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)tempBlock));
                        PARTICLES.spawn(player.field_70170_p, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        return true;
    }
}

