/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.baku;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.baku.BakuMunchAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.baku.BeroCannonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BakuTsuihoAbility
extends ChargeableAbility {
    public static final BakuTsuihoAbility INSTANCE = new BakuTsuihoAbility();
    private List<ItemStack> projectiles = new ArrayList<ItemStack>();
    private List<Block> loadedProjectiles = new ArrayList<Block>();
    private int limit = 0;

    public BakuTsuihoAbility() {
        super("Baku Tsuiho", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(8.0);
        this.setMaxChargeTime(4.0);
        this.setCancelable();
        this.setDescription("Allows the user to charge multiple blocks from their inventory in their mouth and shoot them all at the same time");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        int projectileSpace = 2;
        if (this.limit > 0 && (this.cooldown - 10.0) % 2.0 == 0.0) {
            BeroCannonProjectile proj = new BeroCannonProjectile(player.field_70170_p, (LivingEntity)player);
            proj.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), player.func_226278_cu_() + 0.3 + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble(), player.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), 0.0f, 0.0f);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f, 3.0f);
            --this.limit;
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        this.limit = 1 + this.loadedProjectiles.size();
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        ItemStack stack;
        if (!this.projectiles.isEmpty() && chargeTime % 10 == 0 && (stack = (ItemStack)this.projectiles.stream().findAny().orElse(null)) != null) {
            if (stack.func_190916_E() > 1) {
                stack.func_190918_g(1);
            } else {
                player.field_71071_by.func_184437_d(stack);
                this.projectiles.remove(stack);
            }
            this.loadedProjectiles.add(((BlockItem)stack.func_77973_b()).func_179223_d());
        }
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        this.loadedProjectiles.clear();
        this.projectiles.clear();
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null || !(item.func_77973_b() instanceof BlockItem) || !BakuMunchAbility.GRIEF_RULE.getApprovedBlocks().stream().anyMatch(p -> p == ((BlockItem)item.func_77973_b()).func_179223_d())) continue;
            this.projectiles.add(item);
        }
        if (!this.projectiles.isEmpty()) {
            return true;
        }
        player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_BLOCKS, new Object[0]));
        return false;
    }
}

