/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bane;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.abilities.bane.SpringHopperAbility;
import xyz.pixelatedw.mineminenomi.abilities.bane.SpringSnipeAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class SpringMovementAbility
extends PassiveAbility {
    public static final SpringMovementAbility INSTANCE = new SpringMovementAbility();
    private boolean startedFalling = false;

    public SpringMovementAbility() {
        super("Spring Movement", AbilityHelper.getDevilFruitCategory());
    }

    @Override
    public void tick(PlayerEntity user) {
        super.tick(user);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)user);
        SpringHopperAbility springHopper = (SpringHopperAbility)props.getEquippedAbility(SpringHopperAbility.INSTANCE);
        SpringSnipeAbility springSnipe = (SpringSnipeAbility)props.getEquippedAbility(SpringSnipeAbility.INSTANCE);
        if (this.isPaused()) {
            if (user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_180374_a(this.getAtribute(0))) {
                user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(this.getAtribute(0));
            }
            springHopper.jumpPower = 0;
            return;
        }
        if (springSnipe != null && springSnipe.isCharging()) {
            user.func_213293_j(0.0, 0.0, 0.0);
            return;
        }
        if (springHopper == null) {
            return;
        }
        if (springHopper.isContinuous()) {
            Vec3d speed;
            if (user.field_70123_F && springHopper.jumpPower > 2) {
                speed = user.func_70676_i(1.0f).func_216372_d(-2.0, -2.0, -2.0);
                user.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
                if (springHopper.jumpPower < 9) {
                    ++springHopper.jumpPower;
                }
                user.field_70170_p.func_184133_a(user, user.func_180425_c(), ModSounds.SPRING_SFX, SoundCategory.PLAYERS, 0.3f, (float)MathHelper.func_151237_a((double)(user.func_70681_au().nextDouble() + (double)0.3f), (double)0.8f, (double)1.5));
            }
            if (user.field_70122_E) {
                this.startedFalling = true;
                if (AbilityHelper.isJumping((LivingEntity)user)) {
                    if (springHopper.jumpPower > 3) {
                        speed = WyHelper.propulsion((LivingEntity)user, 0.25 + (double)springHopper.jumpPower * 0.25, 0.25 + (double)springHopper.jumpPower * 0.25);
                        user.func_213293_j(speed.field_72450_a, user.func_213322_ci().field_72448_b, speed.field_72449_c);
                    }
                    if (springHopper.jumpPower < 9 && springHopper.canIncreaseJumpPower) {
                        ++springHopper.jumpPower;
                    }
                    if (user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111126_e() != (double)springHopper.jumpPower * 1.5) {
                        user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(this.getAtribute(springHopper.jumpPower));
                        user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111121_a(this.getAtribute(springHopper.jumpPower));
                    }
                    user.field_70170_p.func_184133_a(user, user.func_180425_c(), ModSounds.SPRING_SFX, SoundCategory.PLAYERS, 0.3f, (float)MathHelper.func_151237_a((double)(user.func_70681_au().nextDouble() + (double)0.3f), (double)0.8f, (double)1.5));
                    springHopper.canIncreaseJumpPower = true;
                } else {
                    springHopper.jumpPower = 0;
                }
            } else {
                if (user.field_70124_G) {
                    --springHopper.jumpPower;
                }
                if (0.0 > user.func_213322_ci().field_72448_b) {
                    if (this.startedFalling) {
                        springHopper.canIncreaseJumpPower = DevilFruitHelper.getDifferenceToFloor(user) > (double)springHopper.jumpPower;
                        this.startedFalling = false;
                    }
                    if (springHopper.jumpPower > 3) {
                        user.func_213317_d(user.func_213322_ci().func_216372_d(1.15, 1.15, 1.15));
                    }
                }
            }
        } else {
            if (user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_180374_a(this.getAtribute(0))) {
                user.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(this.getAtribute(0));
            }
            springHopper.jumpPower = 0;
        }
    }

    public AttributeModifier getAtribute(int jumpPower) {
        return new AttributeModifier(UUID.fromString("a44a9644-369a-4e18-88d9-323727d3d85b"), "Spring Movement Modifier", (double)jumpPower * 1.5, AttributeModifier.Operation.MULTIPLY_BASE).func_111168_a(false);
    }
}

