/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.blackleg.BienCuitGrillShotParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class BienCuitGrillShotAbility
extends Ability
implements IMultiTargetAbility {
    public static final BienCuitGrillShotAbility INSTANCE = new BienCuitGrillShotAbility();
    private static final ParticleEffect PARTICLES = new BienCuitGrillShotParticleEffect();

    public BienCuitGrillShotAbility() {
        super("Bien Cuit: Grill Shot", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(20.0);
        this.setDescription("A strong kick that launches the user forwards and creates a grill-patterened particle to appear, which sets anyone touching it on fire");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        DiableJambeAbility diableJambeAbility = props.getEquippedAbility(DiableJambeAbility.INSTANCE);
        if (diableJambeAbility == null || !diableJambeAbility.isContinuous()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_DIABLE_JAMBE, new Object[0]));
            return false;
        }
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
        player.func_213293_j(speed.field_72450_a, 0.3, speed.field_72449_c);
        player.field_70133_I = true;
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c);
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.8, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity entity : targets) {
                if (!this.isTarget(entity)) continue;
                entity.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 30.0f);
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 2.0, 2.0);
                entity.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
                entity.field_70133_I = true;
                entity.func_70015_d(2);
            }
        }
    }

    public boolean canDealDamage() {
        return this.getCooldownPercentage() > 80.0;
    }
}

