/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.rokushiki.GeppoParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class SkywalkAbility
extends Ability
implements IFallDamageBlockingAbility {
    public static final SkywalkAbility INSTANCE = new SkywalkAbility();
    public static final ParticleEffect PARTICLES = new GeppoParticleEffect();
    public int airJumps = 0;
    private boolean hasFallDamage = true;

    public SkywalkAbility() {
        super("Skywalk", AbilityHelper.getStyleCategory());
        this.setInPool(AbilityPool.GEPPO_LIKE);
        this.setMaxCooldown(1.0);
        this.setDescription("Allows the user to kick the air beneath them and launch themselves into the air");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!player.func_70090_H()) {
            if (player.field_70122_E) {
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 1.0, 1.0);
                player.func_213293_j(speed.field_72450_a, 1.86, speed.field_72449_c);
            } else {
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 1.5, 1.5);
                player.func_213293_j(speed.field_72450_a, 1.25, speed.field_72449_c);
            }
        } else {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 2.5, 2.5, 2.5);
            player.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            this.setMaxCooldown(4 + this.airJumps * 2);
            AbilityHelper.setAirJumps(player, 0);
            this.hasFallDamage = false;
            player.field_70133_I = true;
            this.startCooldown(player);
            return true;
        }
        AbilityHelper.setAirJumps(player, this.airJumps + 1);
        player.field_70133_I = true;
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GEPPO_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        this.hasFallDamage = false;
        int maxJumps = (int)WyHelper.clamp(Math.round((double)EntityStatsCapability.get((LivingEntity)player).getDoriki() * 6.0E-4), 2L, 6L);
        if (this.airJumps >= maxJumps) {
            this.setMaxCooldown((double)this.airJumps * 2.5);
            this.startCooldown(player);
            AbilityHelper.setAirJumps(player, 0);
            return true;
        }
        this.setMaxCooldown(1.0);
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        if (this.airJumps > 0) {
            this.setMaxCooldown((float)this.airJumps * 2.5f);
            this.startCooldown((PlayerEntity)player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((PlayerEntity)player, this), player);
            this.checkAbilityPool((PlayerEntity)player, Ability.State.COOLDOWN);
        }
        this.hasFallDamage = true;
        AbilityHelper.setAirJumps((PlayerEntity)player, 0);
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

