/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class SpinningBrawlAbility
extends ChargeableAbility {
    public static final SpinningBrawlAbility INSTANCE = new SpinningBrawlAbility();
    private LivingEntity grabbedEntity = null;
    private int yaw = 0;

    public SpinningBrawlAbility() {
        super("Spinning Brawl", AbilityHelper.getStyleCategory());
        this.setDescription("Grabs an opponent from the back and launches it into the ground");
        this.setMaxCooldown(40.0);
        this.setMaxChargeTime(5.0);
        this.onStartChargingEvent = this::onUseEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 3.0);
        if (mop instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
            if (entityRayTraceResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)entityRayTraceResult.func_216348_a();
                if (!e.func_70089_S() || DevilFruitCapability.get(e).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, e)) {
                    return false;
                }
                this.grabbedEntity = e;
            }
        } else {
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        if (!this.grabbedEntity.func_70089_S() || DevilFruitCapability.get(this.grabbedEntity).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, this.grabbedEntity)) {
            this.stopCharging(player);
        }
        this.grabbedEntity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        this.grabbedEntity.func_213293_j(0.0, 0.0, 0.0);
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        if (this.yaw + 10 > 360) {
            this.yaw = 0;
        }
        this.yaw += 10;
        float distance = 2.0f;
        Vec3d lookVec = player.func_70040_Z();
        Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * (double)distance, player.func_226278_cu_() + (double)(player.func_70047_e() / 2.0f) + lookVec.field_72448_b * (double)distance, player.func_226281_cx_() + lookVec.field_72449_c * (double)distance);
        player.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (float)this.yaw, 0.0f);
        player.func_70634_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        this.grabbedEntity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        List<LivingEntity> list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, 4.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        list.remove(this.grabbedEntity);
        if (!HakiHelper.hasHardeningActive((LivingEntity)player)) {
            list.removeIf(entity -> DevilFruitCapability.get(entity).isLogia());
        }
        list.forEach(e -> {
            boolean hit = e.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 8.0f);
            if (hit) {
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 2.0, 2.0);
                e.func_213293_j(speed.field_72450_a, 1.0, speed.field_72449_c);
                e.field_70133_I = true;
            }
        });
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.grabbedEntity == null || this.getChargeTime() >= this.getMaxChargeTime()) {
            return false;
        }
        this.grabbedEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 20.0f);
        return true;
    }
}

