/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.brawler.TatsumakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class TatsuMakiAbility
extends Ability
implements IMultiTargetAbility {
    public static final TatsuMakiAbility INSTANCE = new TatsuMakiAbility();
    public static final ParticleEffect PARTICLES = new TatsumakiParticleEffect();

    public TatsuMakiAbility() {
        super("Tatsu Maki", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(8.0);
        this.setDescription("By spinning, the user creates a small tornado, which weakens nearby opponents and sends them flying a bit.");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseBrawlerAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST, new Object[0]));
            return false;
        }
        this.clearTargets();
        List list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 2.5, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        list.stream().forEach(entity -> {
            if (this.isTarget((LivingEntity)entity)) {
                entity.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 20.0f);
                Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
                entity.func_213293_j(speed.field_72450_a, 1.5, speed.field_72449_c);
                entity.field_70133_I = true;
            }
        });
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        return true;
    }
}

